/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.lesto.modules.utilities;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.media.jai.iterator.WritableRandomIter;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import oms3.annotations.Unit;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.geometry.jts.ReferencedEnvelope3D;
import org.hortonmachine.gears.io.las.ALasDataManager;
import org.hortonmachine.gears.io.las.core.LasRecord;
import org.hortonmachine.gears.libs.exceptions.ModelsIOException;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.utils.RegionMap;
import org.hortonmachine.gears.utils.chart.Scatter;
import org.hortonmachine.gears.utils.coverage.CoverageUtilities;
import org.hortonmachine.gears.utils.geometry.GeometryUtilities;
import org.hortonmachine.gears.utils.math.NumericsUtilities;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Description(value="Creates vertical slices of a las file. The resulting raster will have the slice height value as valid pixel value.")
@Author(name="Andrea Antonello, Silvia Franceschi", contact="www.hydrologis.com")
@Keywords(value="slices, lidar, las")
@Label(value="Lesto/utilities")
@Name(value="lasslicer")
@Status(value=10)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class LasSlicer
extends HMModel {
    @Description(value="Las file or folder path.")
    @UI(value="infile_las")
    @In
    public String inLas = null;
    @Description(value="DTM path for normalization.")
    @UI(value="infile_raster")
    @In
    public String inDtm = null;
    @Description(value="The slicing interval.")
    @In
    @Unit(value="m")
    public double pInterval = 1.0;
    @Description(value="The slice thickness.")
    @In
    @Unit(value="m")
    public double pThickness = 0.8;
    @Description(value="Threshold from ground (-1 means no threshold).")
    @In
    @Unit(value="m")
    public double pGroundThreshold = 0.5;
    @Description(value="Type of output to use.")
    @UI(value="combo: chart, raster")
    @In
    public String pMode = "raster";
    @Description(value="Raster resolution in case of raster mode..")
    @In
    @Unit(value="m")
    public double pResolution = 0.5;

    @Execute
    public void process() throws Exception {
        File lasFile;
        File parentFile;
        File outputFolder;
        this.checkNull(new Object[]{this.inLas});
        boolean doRaster = true;
        if (this.pMode.equals("chart")) {
            doRaster = false;
        }
        if (!(outputFolder = new File(parentFile = (lasFile = new File(this.inLas)).getParentFile(), "vertical_slices")).exists() && !outputFolder.mkdir()) {
            throw new ModelsIOException("Can't create folder: " + outputFolder, (Object)this);
        }
        GridCoverage2D dtm = this.getRaster(this.inDtm);
        try (ALasDataManager dataManager = ALasDataManager.getDataManager((File)lasFile, (GridCoverage2D)dtm, (double)this.pGroundThreshold, null);){
            dataManager.open();
            ReferencedEnvelope3D dataEnvelope = dataManager.getEnvelope3D();
            CoordinateReferenceSystem crs = dataEnvelope.getCoordinateReferenceSystem();
            double minX = dataEnvelope.getMinX();
            double minY = dataEnvelope.getMinY();
            double minZ = dataEnvelope.getMinZ();
            double maxX = dataEnvelope.getMaxX();
            double maxY = dataEnvelope.getMaxY();
            double maxZ = dataEnvelope.getMaxZ();
            double xDelta = maxX - minX;
            double yDelta = maxY - minY;
            int chartWidth = 1600;
            int chartHeigth = (int)((double)chartWidth * yDelta / xDelta);
            this.pm.message("Generating charts of " + chartWidth + "x" + chartHeigth);
            double[] xRange = NumericsUtilities.range2Bins((double)minX, (double)maxX, (double)3.0, (boolean)false);
            double[] yRange = NumericsUtilities.range2Bins((double)minY, (double)maxY, (double)3.0, (boolean)false);
            int tilesNum = xRange.length * yRange.length;
            int tilesCount = 0;
            LinkedHashMap<String, ArrayList<LasRecord>> recordsMap = new LinkedHashMap<String, ArrayList<LasRecord>>();
            this.pm.beginTask("Producing slices...", xRange.length - 1);
            for (int x = 0; x < xRange.length - 1; ++x) {
                for (int y = 0; y < yRange.length - 1; ++y) {
                    Envelope env = new Envelope(xRange[x], xRange[x + 1], yRange[y], yRange[y + 1]);
                    Polygon polygon = GeometryUtilities.createPolygonFromEnvelope((Envelope)env);
                    List pointsInGeometry = dataManager.getPointsInGeometry((Geometry)polygon, true);
                    this.pm.message("Points in tile " + x + "/" + y + "(" + ++tilesCount + " of " + tilesNum + "): " + pointsInGeometry.size());
                    if (pointsInGeometry.size() == 0) continue;
                    for (double z = minZ + this.pInterval; z < maxZ; z += this.pInterval) {
                        double high;
                        double height;
                        double low;
                        List pointsInHeightRange;
                        String key = String.valueOf(z);
                        ArrayList<LasRecord> pointsInSlice = (ArrayList<LasRecord>)recordsMap.get(key);
                        if (pointsInSlice == null) {
                            pointsInSlice = new ArrayList<LasRecord>();
                            recordsMap.put(key, pointsInSlice);
                        }
                        if ((pointsInHeightRange = ALasDataManager.getPointsInHeightRange((List)pointsInGeometry, (double)(low = (height = z - minZ) - this.pThickness / 2.0), (double)(high = height + this.pThickness / 2.0))).size() <= 0) continue;
                        pointsInSlice.addAll(pointsInHeightRange);
                        if (doRaster) continue;
                        this.chartPoints(outputFolder, height, pointsInSlice, chartWidth, chartHeigth, minX, maxX, minY, maxY);
                    }
                }
                this.pm.worked(1);
            }
            this.pm.done();
            if (doRaster) {
                Set entrySet = recordsMap.entrySet();
                int size = entrySet.size();
                this.pm.beginTask("Generating rasters...", size);
                for (Map.Entry entry : entrySet) {
                    double z = Double.parseDouble((String)entry.getKey());
                    double height = z - minZ;
                    List points = (List)entry.getValue();
                    this.dumpRaster(outputFolder, height, points, this.pResolution, minX, maxX, minY, maxY, crs);
                    this.pm.worked(1);
                }
                this.pm.done();
            }
        }
    }

    private void dumpRaster(File outputFolder, double height, List<LasRecord> points, double resolution, double minX, double maxX, double minY, double maxY, CoordinateReferenceSystem crs) throws Exception {
        File rasterFile = new File(outputFolder, "slice_" + height + ".asc");
        int rows = (int)Math.round((maxY - minY) / resolution);
        int cols = (int)Math.round((maxX - minX) / resolution);
        GridGeometry2D gridGeometry = CoverageUtilities.gridGeometryFromRegionValues((double)maxY, (double)minY, (double)maxX, (double)minX, (int)cols, (int)rows, (CoordinateReferenceSystem)crs);
        RegionMap regionMap = CoverageUtilities.gridGeometry2RegionParamsMap((GridGeometry2D)gridGeometry);
        WritableRaster outWR = CoverageUtilities.createWritableRaster((int)cols, (int)rows, null, null, (Object)-9999.0);
        WritableRandomIter outIter = CoverageUtilities.getWritableRandomIterator((WritableRaster)outWR);
        Point point = new Point();
        for (LasRecord dot : points) {
            CoverageUtilities.colRowFromCoordinate((Coordinate)new Coordinate(dot.x, dot.y), (GridGeometry2D)gridGeometry, (Point)point);
            outIter.setSample(point.x, point.y, 0, height);
        }
        outIter.done();
        GridCoverage2D outRaster = CoverageUtilities.buildCoverage((String)rasterFile.getName(), (WritableRaster)outWR, (HashMap)regionMap, (CoordinateReferenceSystem)crs);
        this.dumpRaster(outRaster, rasterFile.getAbsolutePath());
    }

    private void chartPoints(File chartFolder, double z, List<LasRecord> pointsInSlice, int width, int height, double minX, double maxX, double minY, double maxY) throws IOException {
        File chartFile = new File(chartFolder, "slice_" + z + ".png");
        int size = pointsInSlice.size();
        double[] xPlanim = new double[size];
        double[] yPlanim = new double[size];
        for (int i = 0; i < size; ++i) {
            LasRecord dot = pointsInSlice.get(i);
            xPlanim[i] = dot.x;
            yPlanim[i] = dot.y;
        }
        Scatter scatterPlanim = new Scatter("Slice " + z);
        scatterPlanim.addSeries("planimetry", xPlanim, yPlanim);
        scatterPlanim.setShowLines(false);
        scatterPlanim.setXLabel("longitude");
        scatterPlanim.setYLabel("latitude");
        scatterPlanim.setXRange(minX, maxX);
        scatterPlanim.setYRange(minY, maxY);
        BufferedImage imagePlanim = scatterPlanim.getImage(width, height);
        ImageIO.write((RenderedImage)imagePlanim, "png", chartFile);
    }
}

