/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.lesto.modules.utilities;

import java.io.File;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.geometry.jts.ReferencedEnvelope3D;
import org.hortonmachine.gears.io.las.core.ALasReader;
import org.hortonmachine.gears.io.las.core.ALasWriter;
import org.hortonmachine.gears.io.las.core.ILasHeader;
import org.hortonmachine.gears.io.las.core.LasRecord;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Description(value="A las file translator.")
@Author(name="Andrea Antonello", contact="www.hydrologis.com")
@Keywords(value="las, translate")
@Label(value="Lesto/utilities")
@Name(value="lastranslator")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class LasTranslator
extends HMModel {
    @Description(value="The las file to handle.")
    @UI(value="infile_las")
    @In
    public String inFile;
    @Description(value="The translation along X.")
    @In
    public double pXTranslate = 0.0;
    @Description(value="The translation along Y.")
    @In
    public double pYTranslate = 0.0;
    @Description(value="The translation along Z.")
    @In
    public double pZTranslate = 0.0;
    @Description(value="The translated las file.")
    @UI(value="outfile")
    @In
    public String outFile;

    @Execute
    public void process() throws Exception {
        this.checkNull(new Object[]{this.inFile});
        File inLas = new File(this.inFile);
        try (ALasReader reader = ALasReader.getReader((File)inLas, null);){
            reader.open();
            ILasHeader header = reader.getHeader();
            long recordsNum = header.getRecordsCount();
            ReferencedEnvelope3D env = header.getDataEnvelope();
            double minX = env.getMinX() + this.pXTranslate;
            double maxX = env.getMaxX() + this.pXTranslate;
            double minY = env.getMinY() + this.pYTranslate;
            double maxY = env.getMaxY() + this.pYTranslate;
            double minZ = env.getMinZ() + this.pZTranslate;
            double maxZ = env.getMaxZ() + this.pZTranslate;
            double[] xyzScale = header.getXYZScale();
            double[] xyzOffset = header.getXYZOffset();
            File outLas = new File(this.outFile);
            try (ALasWriter writer = ALasWriter.getWriter((File)outLas, (CoordinateReferenceSystem)env.getCoordinateReferenceSystem());){
                writer.setBounds(minX, maxX, minY, maxY, minZ, maxZ);
                writer.setScales(xyzScale[0], xyzScale[1], xyzScale[2]);
                writer.setOffset(xyzOffset[0], xyzOffset[1], xyzOffset[2]);
                writer.open();
                this.pm.beginTask("Translating las...", (int)recordsNum);
                while (reader.hasNextPoint()) {
                    LasRecord dot = reader.getNextPoint();
                    dot.x += this.pXTranslate;
                    dot.y += this.pYTranslate;
                    dot.z += this.pZTranslate;
                    writer.addPoint(dot);
                    this.pm.worked(1);
                }
                this.pm.done();
            }
        }
    }
}

