/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.lesto.modules.vegetation;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import oms3.annotations.Unit;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.lesto.modules.vegetation.OmsGeomorphonMaximaFinder;

@Description(value="The Geomorphon method to extract maxima from rasters")
@Author(name="Andrea Antonello, Silvia Franceschi", contact="www.hydrologis.com")
@Keywords(value="raster, maxima, geomorphon")
@Label(value="Lesto/vegetation")
@Name(value="geomorphonmaximafinder")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class GeomorphonMaximaFinder
extends HMModel {
    @Description(value="The DTM.")
    @UI(value="infile_raster")
    @In
    public String inDTM;
    @Description(value="The DSM.")
    @UI(value="infile_raster")
    @In
    public String inDSM;
    @Description(value="Maximum search radius")
    @Unit(value="m")
    @In
    public double pRadius;
    @Description(value="Vertical angle threshold.")
    @Unit(value="degree")
    @In
    public double pThreshold = 1.0;
    @Description(value="Elevation difference threshold.")
    @Unit(value="m")
    @In
    public double pElevDiffThres = 1.0;
    @Description(value="Extracted maxima.")
    @UI(value="outfile")
    @In
    public String outMaxima;

    @Execute
    public void process() throws Exception {
        OmsGeomorphonMaximaFinder gmf = new OmsGeomorphonMaximaFinder();
        gmf.inDSM = this.getRaster(this.inDSM);
        gmf.inDTM = this.getRaster(this.inDTM);
        gmf.pRadius = this.pRadius;
        gmf.pThreshold = this.pThreshold;
        gmf.pElevDiffThres = this.pElevDiffThres;
        gmf.pm = this.pm;
        gmf.process();
        this.dumpVector(gmf.outMaxima, this.outMaxima);
    }
}

