/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.lesto.modules.vegetation;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.media.jai.iterator.RandomIter;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import org.geotools.coverage.grid.GridCoordinates2D;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.DirectPosition2D;
import org.hortonmachine.gears.io.las.core.LasRecord;
import org.hortonmachine.gears.io.las.utils.LasUtils;
import org.hortonmachine.gears.libs.exceptions.ModelsIllegalargumentException;
import org.hortonmachine.gears.libs.modules.GridNode;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.libs.monitor.IHMProgressMonitor;
import org.hortonmachine.gears.utils.RegionMap;
import org.hortonmachine.gears.utils.coverage.CoverageUtilities;
import org.hortonmachine.gears.utils.features.FeatureUtilities;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Description(value="Module that identifies local maxima in point clouds.")
@Author(name="Andrea Antonello, Silvia Franceschi", contact="www.hydrologis.com")
@Keywords(value="Local maxima, las, lidar")
@Label(value="Lesto/vegetation")
@Name(value="_pointcloudmaximafinder")
@Status(value=10)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class OmsPointCloudMaximaFinder
extends HMModel {
    @Description(value="The input las.")
    @In
    public List<LasRecord> inLas = null;
    @Description(value="A dtm raster to use for the area of interest and to calculate the elevation threshold.")
    @In
    public GridCoverage2D inDtm;
    @Description(value="A set of polygons to use as region of interest.")
    @In
    public SimpleFeatureCollection inRoi;
    @Description(value="An optional dsm-dtm difference raster to use to check on the extracted tops.")
    @In
    public GridCoverage2D inDsmDtmDiff;
    @Description(value="Radius for which a point can be local maxima.")
    @In
    public double pMaxRadius = -1.0;
    @Description(value="Use an adaptive radius based on the height.")
    @In
    public boolean doDynamicRadius = true;
    @Description(value="Max permitted elevation difference around the maxima.")
    @In
    public double pElevDiffThres = 3.5;
    @Description(value="The output local maxima.")
    @In
    public SimpleFeatureCollection outTops = null;
    public static final String outTops_DESCR = "The output local maxima.";
    public static final String pClass_DESCR = "The comma separated list of classes to filter (if empty, all are picked).";
    public static final String pThreshold_DESCR = "The elevation threshold to apply to the chm.";
    public static final String pElevDiffThres_DESCR = "Max permitted elevation difference around the maxima.";
    public static final String doDynamicRadius_DESCR = "Use an adaptive radius based on the height.";
    public static final String pMaxRadius_DESCR = "Radius for which a point can be local maxima.";
    public static final String inDsmDtmDiff_DESCR = "An optional dsm-dtm difference raster to use to check on the extracted tops.";
    public static final String inRoi_DESCR = "A set of polygons to use as region of interest.";
    public static final String inDtm_DESCR = "A dtm raster to use for the area of interest and to calculate the elevation threshold.";
    public static final String inLas_DESCR = "The input las.";
    public static final String NAME = "pointcloudmaximafinder";
    public static final String KEYWORDS = "Local maxima, las, lidar";
    public static final String DESCR = "Module that identifies local maxima in point clouds.";
    public static final String LABEL = "Lesto/vegetation";
    private AtomicInteger index = new AtomicInteger();

    @Execute
    public void process() throws Exception {
        this.checkNull(new Object[]{this.inLas});
        if (this.inRoi == null && this.inDtm == null) {
            throw new ModelsIllegalargumentException("At least one of raster or vector roi is necessary.", (Object)this);
        }
        CoordinateReferenceSystem crs = null;
        List<Object> regionGeometries = new ArrayList<Polygon>();
        if (this.inRoi != null) {
            regionGeometries = FeatureUtilities.featureCollectionToGeometriesList((SimpleFeatureCollection)this.inRoi, (boolean)true, null);
            crs = this.inRoi.getBounds().getCoordinateReferenceSystem();
        } else {
            Polygon polygon = CoverageUtilities.getRegionPolygon((GridCoverage2D)this.inDtm);
            regionGeometries.add(polygon);
            crs = this.inDtm.getCoordinateReferenceSystem();
        }
        this.outTops = new DefaultFeatureCollection();
        SimpleFeatureBuilder lasBuilder = LasUtils.getLasFeatureBuilder((CoordinateReferenceSystem)crs);
        DsmDtmDiffHelper helper = null;
        if (this.inDsmDtmDiff != null) {
            helper = new DsmDtmDiffHelper();
            helper.pElevDiffThres = this.pElevDiffThres;
            helper.gridGeometry = this.inDsmDtmDiff.getGridGeometry();
            RegionMap regionMap = CoverageUtilities.getRegionParamsFromGridCoverage((GridCoverage2D)this.inDsmDtmDiff);
            helper.cols = regionMap.getCols();
            helper.rows = regionMap.getRows();
            helper.xres = regionMap.getXres();
            helper.yres = regionMap.getYres();
            helper.dsmDtmDiffIter = CoverageUtilities.getRandomIterator((GridCoverage2D)this.inDsmDtmDiff);
        }
        try {
            OmsPointCloudMaximaFinder.doProcess(this.inLas, this.pMaxRadius, this.doDynamicRadius, helper, (DefaultFeatureCollection)this.outTops, lasBuilder, this.index, this.pm);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (helper != null) {
            helper.dsmDtmDiffIter.done();
        }
    }

    public static void doProcess(final List<LasRecord> pointsInTile, final double pMaxRadius, final boolean doDynamicRadius, final DsmDtmDiffHelper helper, final DefaultFeatureCollection outTopsFC, final SimpleFeatureBuilder lasBuilder, final AtomicInteger index, final IHMProgressMonitor pm) throws Exception {
        final GeometryFactory gf = new GeometryFactory();
        pm.beginTask("Mark local maxima...", pointsInTile.size());
        ExecutorService fixedThreadPool = Executors.newFixedThreadPool(OmsPointCloudMaximaFinder.getDefaultThreadsNum());
        for (final LasRecord currentDot : pointsInTile) {
            Runnable runner = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block14: {
                        try {
                            boolean isLocalMaxima = true;
                            for (LasRecord tmpDot : pointsInTile) {
                                double distance = LasUtils.distance((LasRecord)currentDot, (LasRecord)tmpDot);
                                double maxRadius = pMaxRadius;
                                if (doDynamicRadius && (maxRadius = (2.51503 + 0.00901 * Math.pow(currentDot.groundElevation, 2.0)) / 2.0 * 0.7) > pMaxRadius) {
                                    maxRadius = pMaxRadius;
                                }
                                if (distance > maxRadius || !(tmpDot.groundElevation > currentDot.groundElevation)) continue;
                                isLocalMaxima = false;
                                break;
                            }
                            if (!isLocalMaxima) break block14;
                            if (helper != null) {
                                GridCoordinates2D gridCoord = helper.gridGeometry.worldToGrid((DirectPosition)new DirectPosition2D(currentDot.x, currentDot.y));
                                GridNode node = new GridNode(helper.dsmDtmDiffIter, helper.cols, helper.rows, helper.xres, helper.yres, gridCoord.x, gridCoord.y);
                                double topElevation = node.elevation;
                                if (!node.isValid() || node.touchesBound()) {
                                    isLocalMaxima = false;
                                } else {
                                    List validSurroundingNodes = node.getValidSurroundingNodes();
                                    for (GridNode tmpNode : validSurroundingNodes) {
                                        double tmpElevation = tmpNode.elevation;
                                        if (!(Math.abs(topElevation - tmpElevation) > helper.pElevDiffThres)) continue;
                                        isLocalMaxima = false;
                                    }
                                }
                            }
                            if (!isLocalMaxima) break block14;
                            SimpleFeatureBuilder simpleFeatureBuilder = lasBuilder;
                            synchronized (simpleFeatureBuilder) {
                                Point point = gf.createPoint(new Coordinate(currentDot.x, currentDot.y));
                                double groundElevation = currentDot.groundElevation;
                                groundElevation = (double)((int)Math.round(groundElevation * 10.0)) / 10.0;
                                Object[] values = new Object[]{point, index.getAndIncrement(), groundElevation, currentDot.intensity, currentDot.classification, currentDot.returnNumber, currentDot.numberOfReturns};
                                lasBuilder.addAll(values);
                                SimpleFeature feature = lasBuilder.buildFeature(null);
                                outTopsFC.add(feature);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        finally {
                            pm.worked(1);
                        }
                    }
                }
            };
            fixedThreadPool.execute(runner);
        }
        try {
            fixedThreadPool.shutdown();
            fixedThreadPool.awaitTermination(30L, TimeUnit.DAYS);
            fixedThreadPool.shutdownNow();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        pm.done();
    }

    static class DsmDtmDiffHelper {
        double pElevDiffThres;
        GridGeometry2D gridGeometry;
        RegionMap regionMap;
        int cols;
        int rows;
        double xres;
        double yres;
        RandomIter dsmDtmDiffIter;

        DsmDtmDiffHelper() {
        }
    }
}

