/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.lesto.modules.vegetation;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.hortonmachine.gears.io.las.ALasDataManager;
import org.hortonmachine.gears.io.las.utils.LasUtils;
import org.hortonmachine.gears.libs.exceptions.ModelsIllegalargumentException;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.utils.RegionMap;
import org.hortonmachine.gears.utils.StringUtilities;
import org.hortonmachine.gears.utils.coverage.CoverageUtilities;
import org.hortonmachine.gears.utils.features.FeatureUtilities;
import org.hortonmachine.lesto.modules.vegetation.OmsPointCloudMaximaFinder;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Description(value="Module that identifies local maxima in point clouds.")
@Author(name="Andrea Antonello, Silvia Franceschi", contact="www.hydrologis.com")
@Keywords(value="Local maxima, las, lidar")
@Label(value="Lesto/vegetation")
@Name(value="pointcloudmaximafinder")
@Status(value=10)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class PointCloudMaximaFinder
extends HMModel {
    @Description(value="The input las.")
    @UI(value="infile_las")
    @In
    public String inLas = null;
    @Description(value="A dtm raster to use for the area of interest and to calculate the elevation threshold.")
    @UI(value="infile_raster")
    @In
    public String inDtm;
    @Description(value="A set of polygons to use as region of interest.")
    @UI(value="infile_vector")
    @In
    public String inRoi;
    @Description(value="An optional dsm-dtm difference raster to use to check on the extracted tops.")
    @In
    public GridCoverage2D inDsmDtmDiff;
    @Description(value="Radius for which a point can be local maxima.")
    @In
    public double pMaxRadius = -1.0;
    @Description(value="Use an adaptive radius based on the height.")
    @In
    public boolean doDynamicRadius = true;
    @Description(value="Max permitted elevation difference around the maxima.")
    @In
    public double pElevDiffThres = 3.5;
    @Description(value="The elevation threshold to apply to the chm.")
    @In
    public double pThreshold = 0.0;
    @Description(value="The comma separated list of classes to filter (if empty, all are picked).")
    @In
    public String pClass = null;
    @Description(value="The output local maxima.")
    @UI(value="outfile")
    @In
    public String outTops = null;
    private AtomicInteger featureIndex = new AtomicInteger();

    @Execute
    public void process() throws Exception {
        this.checkNull(new Object[]{this.inLas});
        if (this.inRoi == null && this.inDtm == null) {
            throw new ModelsIllegalargumentException("At least one of raster or vector roi is necessary.", (Object)this);
        }
        GridCoverage2D inDtmGC = null;
        CoordinateReferenceSystem crs = null;
        List regionGeometries = new ArrayList<Polygon>();
        if (this.inRoi != null) {
            SimpleFeatureCollection inRoiFC = this.getVector(this.inRoi);
            regionGeometries = FeatureUtilities.featureCollectionToGeometriesList((SimpleFeatureCollection)inRoiFC, (boolean)true, null);
            crs = inRoiFC.getBounds().getCoordinateReferenceSystem();
        } else {
            inDtmGC = this.getRaster(this.inDtm);
            Polygon polygon = CoverageUtilities.getRegionPolygon((GridCoverage2D)inDtmGC);
            regionGeometries.add(polygon);
            crs = inDtmGC.getCoordinateReferenceSystem();
        }
        OmsPointCloudMaximaFinder.DsmDtmDiffHelper helper = null;
        if (this.inDsmDtmDiff != null) {
            helper = new OmsPointCloudMaximaFinder.DsmDtmDiffHelper();
            helper.pElevDiffThres = this.pElevDiffThres;
            helper.gridGeometry = this.inDsmDtmDiff.getGridGeometry();
            RegionMap regionMap = CoverageUtilities.getRegionParamsFromGridCoverage((GridCoverage2D)this.inDsmDtmDiff);
            helper.cols = regionMap.getCols();
            helper.rows = regionMap.getRows();
            helper.xres = regionMap.getXres();
            helper.yres = regionMap.getYres();
            helper.dsmDtmDiffIter = CoverageUtilities.getRandomIterator((GridCoverage2D)this.inDsmDtmDiff);
        }
        try (ALasDataManager lasData = ALasDataManager.getDataManager((File)new File(this.inLas), (GridCoverage2D)inDtmGC, (double)this.pThreshold, (CoordinateReferenceSystem)crs);){
            lasData.open();
            if (this.pClass != null) {
                double[] classes = StringUtilities.stringToDoubleArray((String)this.pClass, (String)",");
                lasData.setClassesConstraint(classes);
            }
            DefaultFeatureCollection outTopsFC = new DefaultFeatureCollection();
            SimpleFeatureBuilder lasBuilder = LasUtils.getLasFeatureBuilder((CoordinateReferenceSystem)crs);
            int roiNum = regionGeometries.size();
            int index = 1;
            for (Geometry regionGeometry : regionGeometries) {
                StringBuilder sb = new StringBuilder();
                sb.append("\nProcessing geometry N.");
                sb.append(index);
                sb.append(" of ");
                sb.append(roiNum);
                sb.append("\n");
                this.pm.message(sb.toString());
                LineString exteriorRing = ((Polygon)regionGeometry).getExteriorRing();
                Polygon regionPolygon = this.gf.createPolygon(this.gf.createLinearRing(exteriorRing.getCoordinates()));
                List pointsInTile = lasData.getPointsInGeometry((Geometry)regionPolygon, false);
                int size = pointsInTile.size();
                if (size == 0) {
                    this.pm.errorMessage("No points processed in tile: " + regionPolygon);
                    continue;
                }
                try {
                    OmsPointCloudMaximaFinder.doProcess(pointsInTile, this.pMaxRadius, this.doDynamicRadius, helper, outTopsFC, lasBuilder, this.featureIndex, this.pm);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.dumpVector((SimpleFeatureCollection)outTopsFC, this.outTops);
        }
        if (helper != null) {
            helper.dsmDtmDiffIter.done();
        }
    }
}

