/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.lesto.modules.vegetation.watershed;

import java.util.ArrayList;
import java.util.List;

public class WatershedPixel
implements Comparable<WatershedPixel> {
    static final int INIT = -1;
    static final int MASK = -2;
    static final int WSHED = 0;
    static final int FICTITIOUS = -3;
    private int x;
    private int y;
    private byte height;
    private int label;
    private int dist;
    private List<WatershedPixel> neighbours;

    public WatershedPixel(int x, int y, byte height) {
        this.x = x;
        this.y = y;
        this.height = height;
        this.label = -1;
        this.dist = 0;
        this.neighbours = new ArrayList<WatershedPixel>(8);
    }

    public WatershedPixel() {
        this.label = -3;
    }

    public void addNeighbour(WatershedPixel neighbour) {
        this.neighbours.add(neighbour);
    }

    public List<WatershedPixel> getNeighbours() {
        return this.neighbours;
    }

    public String toString() {
        return new String("(" + this.x + "," + this.y + "), height : " + this.getIntHeight() + ", label : " + this.label + ", distance : " + this.dist);
    }

    public final byte getHeight() {
        return this.height;
    }

    public final int getIntHeight() {
        return this.height & 0xFF;
    }

    public final int getX() {
        return this.x;
    }

    public final int getY() {
        return this.y;
    }

    @Override
    public int compareTo(WatershedPixel o) {
        if (o.getIntHeight() < this.getIntHeight()) {
            return 1;
        }
        if (o.getIntHeight() > this.getIntHeight()) {
            return -1;
        }
        return 0;
    }

    public void setLabel(int label) {
        this.label = label;
    }

    public void setLabelToINIT() {
        this.label = -1;
    }

    public void setLabelToMASK() {
        this.label = -2;
    }

    public void setLabelToWSHED() {
        this.label = 0;
    }

    public boolean isLabelINIT() {
        return this.label == -1;
    }

    public boolean isLabelMASK() {
        return this.label == -2;
    }

    public boolean isLabelWSHED() {
        return this.label == 0;
    }

    public int getLabel() {
        return this.label;
    }

    public void setDistance(int distance) {
        this.dist = distance;
    }

    public int getDistance() {
        return this.dist;
    }

    public boolean isFICTITIOUS() {
        return this.label == -3;
    }

    public boolean allNeighboursAreWSHED() {
        for (int i = 0; i < this.neighbours.size(); ++i) {
            WatershedPixel r = this.neighbours.get(i);
            if (r.isLabelWSHED()) continue;
            return false;
        }
        return true;
    }
}

