/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.lesto.modules.vegetation.watershed;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hortonmachine.gears.libs.monitor.IHMProgressMonitor;
import org.hortonmachine.lesto.modules.vegetation.watershed.WatershedPixel;

public class WatershedStructure {
    private List<WatershedPixel> watershedStructure;

    public WatershedStructure(byte[] pixels, int cols, int rows, IHMProgressMonitor pm) {
        int c;
        int offset;
        int r;
        this.watershedStructure = new ArrayList<WatershedPixel>(cols * rows);
        pm.beginTask("Fill Watershed structure...", rows);
        for (r = 0; r < rows; ++r) {
            offset = r * cols;
            c = 0;
            while (c < cols) {
                int i = offset + c;
                int indiceY = r;
                int indiceX = c++;
                this.watershedStructure.add(new WatershedPixel(indiceX, indiceY, pixels[i]));
            }
            pm.worked(1);
        }
        pm.done();
        pm.beginTask("Add neighbours references...", rows);
        for (r = 0; r < rows; ++r) {
            offset = r * cols;
            int topOffset = offset + cols;
            int bottomOffset = offset - cols;
            for (c = 0; c < cols; ++c) {
                WatershedPixel currentPixel = this.watershedStructure.get(c + offset);
                if (c + 1 < cols) {
                    currentPixel.addNeighbour(this.watershedStructure.get(c + 1 + offset));
                    if (r - 1 >= 0) {
                        currentPixel.addNeighbour(this.watershedStructure.get(c + 1 + bottomOffset));
                    }
                    if (r + 1 < rows) {
                        currentPixel.addNeighbour(this.watershedStructure.get(c + 1 + topOffset));
                    }
                }
                if (c - 1 >= 0) {
                    currentPixel.addNeighbour(this.watershedStructure.get(c - 1 + offset));
                    if (r - 1 >= 0) {
                        currentPixel.addNeighbour(this.watershedStructure.get(c - 1 + bottomOffset));
                    }
                    if (r + 1 < rows) {
                        currentPixel.addNeighbour(this.watershedStructure.get(c - 1 + topOffset));
                    }
                }
                if (r - 1 >= 0) {
                    currentPixel.addNeighbour(this.watershedStructure.get(c + bottomOffset));
                }
                if (r + 1 >= rows) continue;
                currentPixel.addNeighbour(this.watershedStructure.get(c + topOffset));
            }
            pm.worked(1);
        }
        pm.done();
        Collections.sort(this.watershedStructure);
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < this.watershedStructure.size(); ++i) {
            ret.append(this.watershedStructure.get(i).toString());
            ret.append("\n");
            ret.append("Neighbours :\n");
            List<WatershedPixel> neighbours = this.watershedStructure.get(i).getNeighbours();
            for (int j = 0; j < neighbours.size(); ++j) {
                ret.append(neighbours.get(j).toString());
                ret.append("\n");
            }
            ret.append("\n");
        }
        return ret.toString();
    }

    public int size() {
        return this.watershedStructure.size();
    }

    public WatershedPixel get(int i) {
        return this.watershedStructure.get(i);
    }
}

