/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.lesto.modules.vegetation.rastermaxima;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.media.jai.iterator.RandomIter;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import oms3.annotations.UI;
import oms3.annotations.Unit;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.hortonmachine.gears.libs.exceptions.ModelsIllegalargumentException;
import org.hortonmachine.gears.libs.modules.GridNode;
import org.hortonmachine.gears.libs.modules.HMConstants;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.modules.v.vectorize.OmsVectorizer;
import org.hortonmachine.gears.utils.RegionMap;
import org.hortonmachine.gears.utils.coverage.CoverageUtilities;
import org.hortonmachine.gears.utils.features.FeatureUtilities;
import org.hortonmachine.gears.utils.geometry.GeometryUtilities;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.operation.distance.DistanceOp;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Description(value="Module to find local maxima.")
@Author(name="Andrea Antonello, Silvia Franceschi", contact="www.hydrologis.com")
@Keywords(value="Raster, Maxima")
@Label(value="Lesto/vegetation")
@Name(value="_rastermaximafinder")
@Status(value=5)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class OmsRasterMaximaFinder
extends HMModel {
    @Description(value="The input CHM.")
    @In
    public GridCoverage2D inDsmDtmDiff;
    @Description(value="Processing mode.")
    @UI(value="combo:custom,mixed_pines_and_deciduous_trees,deciduous,conifer")
    @In
    public String pMode = "custom";
    @Description(value="Threshold on maxima. Only maxima higher than the threshold are kept.")
    @In
    public double pThreshold = 1.0;
    @Description(value="The windows size in cells to use for custom mode(default is 3).")
    @In
    public int pSize = 3;
    @Description(value="Percentage to apply to the maxima window to downsize it (default is 60%).")
    @In
    public int pPercent = 60;
    @Description(value="Maximum radius to use in meters.")
    @In
    public double pMaxRadius = 3.0;
    @Description(value="Use circular window.")
    @In
    public boolean doCircular = true;
    @Description(value="Distance threshold to mark maxima as near a border. If <0 check is ignored.")
    @Unit(value="m")
    @In
    public double pBorderDistanceThres = -1.0;
    @Description(value="Top buffer threshold")
    @Unit(value="m")
    @In
    public double pTopBufferThres = 5.0;
    @Description(value="Top buffer threshold cell count")
    @In
    public int pTopBufferThresCellCount = 2;
    @Description(value="The maxima vector.")
    @Out
    public SimpleFeatureCollection outMaxima;
    @Description(value="The maxima related areas vector.")
    @Out
    public SimpleFeatureCollection outCircles;
    public SimpleFeatureCollection outBorders;
    public static final String OMSMAXIMAFINDER_DESCRIPTION = "Module to find local maxima.";
    public static final String OMSMAXIMAFINDER_KEYWORDS = "Raster, Maxima";
    public static final String OMSMAXIMAFINDER_LABEL = "Lesto/vegetation";
    public static final String OMSMAXIMAFINDER_NAME = "rastermaximafinder";
    public static final int OMSMAXIMAFINDER_STATUS = 5;
    public static final String inGeodata_DESCRIPTION = "The input CHM.";
    public static final String pThreshold_DESCRIPTION = "Threshold on maxima. Only maxima higher than the threshold are kept.";
    public static final String pMode_DESCRIPTION = "Processing mode.";
    public static final String pPercent_DESCRIPTION = "Percentage to apply to the maxima window to downsize it (default is 60%).";
    public static final String pMaxRadius_DESCRIPTION = "Maximum radius to use in meters.";
    public static final String doCircular_DESCRIPTION = "Use circular window.";
    public static final String pBorderDistanceThres_DESCRIPTION = "Distance threshold to mark maxima as near a border. If <0 check is ignored.";
    public static final String pSize_DESCRIPTION = "The windows size in cells to use for custom mode(default is 3).";
    public static final String outMaxima_DESCRIPTION = "The maxima vector.";
    public static final String outCircles_DESCRIPTION = "The maxima related areas vector.";
    public static final String pTopBufferThresCellCount_DESCRIPTION = "Top buffer threshold cell count";
    public static final String pTopBufferThres_DESCRIPTION = "Top buffer threshold";
    private DecimalFormat formatter = new DecimalFormat("0.0");
    public static final String NOTE = "note";

    @Execute
    public void process() throws Exception {
        this.checkNull(new Object[]{this.inDsmDtmDiff, this.pMode});
        int mode = 0;
        if (this.pMode.equals("custom")) {
            mode = 0;
        } else if (this.pMode.equals("mixed_pines_and_deciduous_trees")) {
            mode = 1;
        } else if (this.pMode.equals("deciduous")) {
            mode = 2;
        } else if (this.pMode.equals("conifer")) {
            mode = 3;
        } else {
            throw new ModelsIllegalargumentException("Processing mode not recognized: " + this.pMode, (Object)this);
        }
        RegionMap regionMap = CoverageUtilities.getRegionParamsFromGridCoverage((GridCoverage2D)this.inDsmDtmDiff);
        int cols = regionMap.getCols();
        int rows = regionMap.getRows();
        double xRes = regionMap.getXres();
        double yRes = regionMap.getYres();
        GridGeometry2D gridGeometry = this.inDsmDtmDiff.getGridGeometry();
        GeometryFactory gf = GeometryUtilities.gf();
        SimpleFeatureTypeBuilder maximaTypeBuilder = new SimpleFeatureTypeBuilder();
        maximaTypeBuilder.setName("pointtype");
        maximaTypeBuilder.setCRS(this.inDsmDtmDiff.getCoordinateReferenceSystem());
        maximaTypeBuilder.add("the_geom", Point.class);
        maximaTypeBuilder.add("id", Integer.class);
        maximaTypeBuilder.add("elev", Double.class);
        maximaTypeBuilder.add(NOTE, String.class);
        SimpleFeatureType maximaType = maximaTypeBuilder.buildFeatureType();
        SimpleFeatureBuilder maximaBuilder = new SimpleFeatureBuilder(maximaType);
        this.outMaxima = new DefaultFeatureCollection();
        SimpleFeatureTypeBuilder circleTypeBuilder = new SimpleFeatureTypeBuilder();
        circleTypeBuilder.setName("pointtype");
        circleTypeBuilder.setCRS(this.inDsmDtmDiff.getCoordinateReferenceSystem());
        circleTypeBuilder.add("the_geom", Polygon.class);
        circleTypeBuilder.add("id_maxima", Integer.class);
        circleTypeBuilder.add("area", Double.class);
        SimpleFeatureType circleType = circleTypeBuilder.buildFeatureType();
        SimpleFeatureBuilder circleBuilder = new SimpleFeatureBuilder(circleType);
        this.outCircles = new DefaultFeatureCollection();
        RandomIter elevIter = CoverageUtilities.getRandomIterator((GridCoverage2D)this.inDsmDtmDiff);
        int id = 1;
        this.pm.beginTask("Finding maxima...", rows);
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                GridNode node = new GridNode(elevIter, cols, rows, xRes, yRes, c, r);
                if (!node.isValid()) continue;
                double elevation = node.elevation;
                int size = 3;
                switch (mode) {
                    case 1: {
                        double windowWidth = 2.51503 + 0.00901 * Math.pow(elevation, 2.0);
                        windowWidth = windowWidth * (double)this.pPercent / 100.0;
                        if (windowWidth > 2.0 * this.pMaxRadius) {
                            windowWidth = 2.0 * this.pMaxRadius;
                        }
                        size = (int)Math.ceil(windowWidth / xRes);
                        break;
                    }
                    case 2: {
                        double windowWidth = 3.09632 + 0.00895 * Math.pow(elevation, 2.0);
                        windowWidth = windowWidth * (double)this.pPercent / 100.0;
                        if (windowWidth > 2.0 * this.pMaxRadius) {
                            windowWidth = 2.0 * this.pMaxRadius;
                        }
                        size = (int)Math.ceil(windowWidth / xRes);
                        break;
                    }
                    case 3: {
                        double windowWidth = 3.75105 + 0.17919 * elevation + 0.01241 * Math.pow(elevation, 2.0);
                        windowWidth = windowWidth * (double)this.pPercent / 100.0;
                        if (windowWidth > 2.0 * this.pMaxRadius) {
                            windowWidth = 2.0 * this.pMaxRadius;
                        }
                        size = (int)Math.ceil(windowWidth / xRes);
                        break;
                    }
                    default: {
                        size = this.pSize;
                    }
                }
                if (size > cols / 2) {
                    throw new ModelsIllegalargumentException("The windows width is larger than half the processing region for elevation = " + elevation, (Object)this);
                }
                boolean tmpDoCircular = this.doCircular;
                if (size <= 3) {
                    size = 3;
                    tmpDoCircular = false;
                }
                double[][] window = node.getWindow(size, tmpDoCircular);
                String note = "";
                boolean isMax = true;
                for (int mrow = 0; mrow < window.length; ++mrow) {
                    for (int mcol = 0; mcol < window[0].length; ++mcol) {
                        if (HMConstants.isNovalue((double)window[mrow][mcol]) || !(window[mrow][mcol] > elevation)) continue;
                        isMax = false;
                        break;
                    }
                    if (!isMax) break;
                }
                if (!isMax) continue;
                int nonValidCells = 0;
                List surroundingNodes = node.getSurroundingNodes();
                int topBufferThresViolationCount = 0;
                for (GridNode gridNode : surroundingNodes) {
                    if (gridNode != null) {
                        double elev = gridNode.elevation;
                        double elevDiff = elevation - elev;
                        if (elevDiff > this.pTopBufferThres) {
                            ++topBufferThresViolationCount;
                        }
                    } else {
                        ++nonValidCells;
                    }
                    if (nonValidCells <= 1) continue;
                    note = "exclude: found invalid neighbor cells = " + nonValidCells;
                    isMax = false;
                    break;
                }
                if (isMax && this.pTopBufferThresCellCount > 0 && topBufferThresViolationCount >= this.pTopBufferThresCellCount) {
                    isMax = false;
                    note = "exclude: elevation diff of neighbors from top violates thres (" + this.pTopBufferThres + "/" + topBufferThresViolationCount + ")";
                }
                if (!isMax || !(elevation >= this.pThreshold)) continue;
                Coordinate coordinate = CoverageUtilities.coordinateFromColRow((int)c, (int)r, (GridGeometry2D)gridGeometry);
                Point point = gf.createPoint(coordinate);
                String elevStr = this.formatter.format(elevation);
                elevStr = elevStr.replace(',', '.');
                elevation = Double.parseDouble(elevStr);
                Object[] values = new Object[]{point, id, elevation, note};
                maximaBuilder.addAll(values);
                SimpleFeature feature = maximaBuilder.buildFeature(null);
                ((DefaultFeatureCollection)this.outMaxima).add(feature);
                double radius = (double)size * xRes / 2.0;
                Geometry buffer = point.buffer(radius);
                values = new Object[]{buffer, id, buffer.getArea()};
                circleBuilder.addAll(values);
                feature = circleBuilder.buildFeature(null);
                ((DefaultFeatureCollection)this.outCircles).add(feature);
                ++id;
            }
            this.pm.worked(1);
        }
        this.pm.done();
        elevIter.done();
        if (this.pBorderDistanceThres > 0.0) {
            OmsVectorizer vectorizer = new OmsVectorizer();
            vectorizer.pm = this.pm;
            vectorizer.inRaster = this.inDsmDtmDiff;
            vectorizer.pValue = null;
            vectorizer.pThres = 0.0;
            vectorizer.doMask = true;
            vectorizer.pMaskThreshold = this.pThreshold;
            vectorizer.fDefault = "rast";
            vectorizer.process();
            SimpleFeatureCollection diffPolygons = vectorizer.outVector;
            List diffGeoms = FeatureUtilities.featureCollectionToGeometriesList((SimpleFeatureCollection)diffPolygons, (boolean)true, null);
            ArrayList<LineString> bordersGeoms = new ArrayList<LineString>();
            for (Geometry geometry : diffGeoms) {
                if (!(geometry instanceof Polygon)) continue;
                Polygon polygon = (Polygon)geometry;
                LineString exteriorRing = polygon.getExteriorRing();
                bordersGeoms.add(exteriorRing);
                int numInteriorRing = polygon.getNumInteriorRing();
                for (int i = 0; i < numInteriorRing; ++i) {
                    LineString interiorRingN = polygon.getInteriorRingN(i);
                    bordersGeoms.add(interiorRingN);
                }
            }
            MultiLineString allBorders = gf.createMultiLineString(bordersGeoms.toArray(GeometryUtilities.TYPE_LINESTRING));
            this.outBorders = FeatureUtilities.featureCollectionFromGeometry((CoordinateReferenceSystem)this.inDsmDtmDiff.getCoordinateReferenceSystem(), (Geometry[])new Geometry[]{allBorders});
            SimpleFeatureIterator maximaIter = this.outMaxima.features();
            while (maximaIter.hasNext()) {
                SimpleFeature maxima = (SimpleFeature)maximaIter.next();
                Geometry maximaGeometry = (Geometry)maxima.getDefaultGeometry();
                double distance = DistanceOp.distance((Geometry)allBorders, (Geometry)maximaGeometry);
                if (!(distance < this.pBorderDistanceThres)) continue;
                maxima.setAttribute(NOTE, (Object)("exclude: near border: " + distance));
            }
            maximaIter.close();
        }
    }
}

