/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.lesto.modules.vector;

import java.awt.Point;
import java.awt.image.WritableRaster;
import java.io.File;
import java.util.HashMap;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.hortonmachine.gears.io.las.core.ALasReader;
import org.hortonmachine.gears.io.las.core.ILasHeader;
import org.hortonmachine.gears.io.las.core.LasRecord;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.modules.v.vectorize.OmsVectorizer;
import org.hortonmachine.gears.utils.RegionMap;
import org.hortonmachine.gears.utils.coverage.CoverageUtilities;
import org.locationtech.jts.geom.Coordinate;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Description(value="Module that creates a vector polygon shape from the las file.")
@Author(name="Andrea Antonello, Silvia Franceschi", contact="www.hydrologis.com")
@Keywords(value="vector, lidar")
@Label(value="Lesto/vector")
@Name(value="lasshapevectorizer")
@Status(value=10)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class LasShapeVectorizer
extends HMModel {
    @Description(value="Las file path.")
    @UI(value="infile_las")
    @In
    public String inLas = null;
    @Description(value="The x resolution to use when rasterizing pre vectorizing.")
    @In
    public double pXres = 0.5;
    @Description(value="The y resolution to use when rasterizing pre vectorizing.")
    @In
    public double pYres = 0.5;
    @Description(value="The output shapefile.")
    @UI(value="outfile")
    @In
    public String outShp = null;

    @Execute
    public void process() throws Exception {
        this.checkNull(new Object[]{this.inLas});
        CoordinateReferenceSystem crs = null;
        double west = Double.POSITIVE_INFINITY;
        double south = Double.POSITIVE_INFINITY;
        double east = Double.NEGATIVE_INFINITY;
        double north = Double.NEGATIVE_INFINITY;
        this.pm.beginTask("Reading real bounds...", -1);
        long recordsCount = 0L;
        try (ALasReader reader = ALasReader.getReader((File)new File(this.inLas), null);){
            reader.open();
            ILasHeader header = reader.getHeader();
            crs = header.getCrs();
            recordsCount = header.getRecordsCount();
            while (reader.hasNextPoint()) {
                LasRecord dot = reader.getNextPoint();
                west = Math.min(west, dot.x);
                south = Math.min(south, dot.y);
                east = Math.max(east, dot.x);
                north = Math.max(north, dot.y);
            }
        }
        this.pm.done();
        int rows = (int)Math.round(((north += this.pYres) - (south -= this.pYres)) / this.pYres);
        int cols = (int)Math.round(((east += this.pXres) - (west -= this.pXres)) / this.pXres);
        east = west + (double)cols * this.pXres;
        north = south + (double)rows * this.pYres;
        GridGeometry2D gridGeometry2D = CoverageUtilities.gridGeometryFromRegionValues((double)north, (double)south, (double)east, (double)west, (int)cols, (int)rows, (CoordinateReferenceSystem)crs);
        RegionMap regionMap = CoverageUtilities.gridGeometry2RegionParamsMap((GridGeometry2D)gridGeometry2D);
        WritableRaster wr = CoverageUtilities.createWritableRaster((int)cols, (int)rows, null, null, (Object)-9999.0);
        this.pm.beginTask("Mapping points on raster...", (int)recordsCount);
        try (ALasReader reader = ALasReader.getReader((File)new File(this.inLas), null);){
            reader.open();
            Point gridPoint = new Point();
            while (reader.hasNextPoint()) {
                LasRecord dot = reader.getNextPoint();
                double dotZ = dot.z;
                Coordinate coordinate = new Coordinate(dot.x, dot.y, dotZ);
                CoverageUtilities.colRowFromCoordinate((Coordinate)coordinate, (GridGeometry2D)gridGeometry2D, (Point)gridPoint);
                wr.setSample(gridPoint.x, gridPoint.y, 0, 1);
                this.pm.worked(1);
            }
        }
        this.pm.done();
        GridCoverage2D gridCoverage2D = CoverageUtilities.buildCoverage((String)"mapped", (WritableRaster)wr, (HashMap)regionMap, (CoordinateReferenceSystem)crs);
        OmsVectorizer vectorizer = new OmsVectorizer();
        vectorizer.inRaster = gridCoverage2D;
        vectorizer.pm = this.pm;
        vectorizer.process();
        SimpleFeatureCollection outVector = vectorizer.outVector;
        this.dumpVector(outVector, this.outShp);
    }
}

