/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.lesto.modules.filter;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.geometry.jts.ReferencedEnvelope3D;
import org.hortonmachine.gears.io.las.core.ALasReader;
import org.hortonmachine.gears.io.las.core.ALasWriter;
import org.hortonmachine.gears.io.las.core.ILasHeader;
import org.hortonmachine.gears.io.las.core.LasRecord;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Description(value="A module that merges las files to a single one.")
@Author(name="Andrea Antonello", contact="www.hydrologis.com")
@Keywords(value="las, merge")
@Label(value="Lesto/filter")
@Name(value="lasmerge")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class LasMerger
extends HMModel {
    @Description(value="A folder of las files to merge.")
    @UI(value="infolder")
    @In
    public String inFolder;
    @Description(value="The merged las output file.")
    @UI(value="outfile")
    @In
    public String outLas;

    @Execute
    public void process() throws Exception {
        this.checkNull(new Object[]{this.inFolder, this.outLas});
        CoordinateReferenceSystem crs = null;
        File inFolderFile = new File(this.inFolder);
        File[] lasList = inFolderFile.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File arg0, String arg1) {
                return arg1.toLowerCase().endsWith(".las");
            }
        });
        StringBuilder sb = new StringBuilder("Merging files:");
        for (File file : lasList) {
            sb.append("\n").append(file.getAbsolutePath());
        }
        this.pm.message(sb.toString());
        ArrayList<ALasReader> readers = new ArrayList<ALasReader>();
        double xMin = Double.POSITIVE_INFINITY;
        double yMin = Double.POSITIVE_INFINITY;
        double zMin = Double.POSITIVE_INFINITY;
        double xMax = Double.NEGATIVE_INFINITY;
        double yMax = Double.NEGATIVE_INFINITY;
        double zMax = Double.NEGATIVE_INFINITY;
        int count = 0;
        for (File lasFile : lasList) {
            ALasReader reader = ALasReader.getReader((File)lasFile, crs);
            reader.open();
            ILasHeader header = reader.getHeader();
            long recordsNum = header.getRecordsCount();
            count = (int)((long)count + recordsNum);
            ReferencedEnvelope3D envelope = header.getDataEnvelope();
            xMin = Math.min(xMin, envelope.getMinX());
            yMin = Math.min(yMin, envelope.getMinY());
            zMin = Math.min(zMin, envelope.getMinZ());
            xMax = Math.max(xMax, envelope.getMaxX());
            yMax = Math.max(yMax, envelope.getMaxY());
            zMax = Math.max(zMax, envelope.getMaxZ());
            readers.add(reader);
        }
        File outFile = new File(this.outLas);
        ALasWriter writer = ALasWriter.getWriter((File)outFile, crs);
        writer.setBounds(xMin, xMax, yMin, yMax, zMin, zMax);
        writer.open();
        this.pm.beginTask("Merging...", count);
        for (ALasReader reader : readers) {
            while (reader.hasNextPoint()) {
                LasRecord readNextLasDot = reader.getNextPoint();
                writer.addPoint(readNextLasDot);
                this.pm.worked(1);
            }
            reader.close();
        }
        writer.close();
        this.pm.done();
    }
}

