/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.lesto.modules.flightlines;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.io.las.core.ALasReader;
import org.hortonmachine.gears.io.las.core.ALasWriter;
import org.hortonmachine.gears.io.las.core.ILasHeader;
import org.hortonmachine.gears.io.las.core.LasRecord;
import org.hortonmachine.gears.io.las.utils.GpsTimeConverter;
import org.hortonmachine.gears.io.las.utils.LasUtils;
import org.hortonmachine.gears.libs.exceptions.ModelsIllegalargumentException;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.utils.chart.CategoryHistogram;
import org.hortonmachine.gears.utils.chart.IChart;
import org.hortonmachine.gears.utils.chart.PlotFrame;
import org.hortonmachine.gears.utils.files.FileUtilities;
import org.joda.time.DateTime;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Description(value="A module that splits las files in its flightlines")
@Author(name="Andrea Antonello", contact="www.hydrologis.com")
@Keywords(value="las, split, flightlines")
@Label(value="Lesto/flightlines")
@Name(value="lasflightlines")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class FlightLinesExtractor
extends HMModel {
    public static final String WEEK_SECONDS_TIME = "Week.seconds time";
    public static final String ADJUSTED_STANDARD_GPS_TIME = "Adjusted Standard GPS Time";
    @Description(value="A las file to split.")
    @UI(value="infile_las")
    @In
    public String inLas;
    @Description(value="The gps time type.")
    @UI(value="combo:Adjusted Standard GPS Time,Week.seconds time")
    @In
    public String pGpsTimeType = "Adjusted Standard GPS Time";
    @Description(value="Plot time markers.")
    @In
    public boolean doPlot = true;
    @Description(value="Output folder.")
    @UI(value="outfolder")
    @In
    public String outFolder;

    @Execute
    public void process() throws Exception {
        this.checkNull(new Object[]{this.inLas, this.outFolder});
        this.checkFileExists(new String[]{this.inLas, this.outFolder});
        int timeType = 1;
        if (this.pGpsTimeType.equals(ADJUSTED_STANDARD_GPS_TIME)) {
            timeType = 1;
        }
        if (this.pGpsTimeType.equals(WEEK_SECONDS_TIME)) {
            timeType = 0;
        }
        File lasFile = new File(this.inLas);
        ALasReader reader = ALasReader.getReader((File)lasFile, null);
        reader.open();
        reader.setOverrideGpsTimeType(timeType);
        ILasHeader header = reader.getHeader();
        int gpsTimeType = header.getGpsTimeType();
        this.pm.message(header.toString());
        CoordinateReferenceSystem crs = header.getCrs();
        if (crs == null) {
            throw new ModelsIllegalargumentException("No crs available for the input data.", (Object)this);
        }
        this.pm.beginTask("Creating histogram...", (int)header.getRecordsCount());
        TreeMap<Long, Integer> histogramMap = new TreeMap<Long, Integer>();
        while (reader.hasNextPoint()) {
            LasRecord readNextLasDot = reader.getNextPoint();
            long dateSeconds = this.getDateSeconds(gpsTimeType, readNextLasDot);
            Integer count = (Integer)histogramMap.get(dateSeconds);
            if (count == null) {
                histogramMap.put(dateSeconds, 0);
            } else {
                histogramMap.put(dateSeconds, count + 1);
            }
            this.pm.worked(1);
        }
        reader.close();
        this.pm.done();
        Set entrySet = histogramMap.entrySet();
        this.pm.beginTask("Defining time markers...", entrySet.size() * 2);
        long[] cat = new long[entrySet.size()];
        double[] values = new double[entrySet.size()];
        int i = 0;
        for (Map.Entry entry : entrySet) {
            cat[i] = (Long)entry.getKey();
            values[i] = ((Integer)entry.getValue()).intValue();
            ++i;
            this.pm.worked(1);
        }
        TreeSet<Long> lineMarkers = new TreeSet<Long>();
        long lastSeconds = 0L;
        for (int j = 1; j < cat.length; ++j) {
            long currentSeconds;
            long prevSeconds = cat[j - 1];
            lastSeconds = currentSeconds = cat[j];
            long seconds = currentSeconds - prevSeconds;
            if (seconds > 30L) {
                lineMarkers.add(prevSeconds);
                this.pm.message("Adding time marker at: " + prevSeconds);
            }
            this.pm.worked(1);
        }
        this.pm.done();
        lineMarkers.add(lastSeconds);
        long[] markersArray = new long[lineMarkers.size()];
        int index = 0;
        for (Long marker : lineMarkers) {
            markersArray[index] = marker;
            ++index;
        }
        File outFolderFile = new File(this.outFolder);
        String nameWithoutExtention = FileUtilities.getNameWithoutExtention((File)lasFile);
        this.pm.beginTask("Splitting flightlines...", (int)header.getRecordsCount());
        ALasWriter[] writers = new ALasWriter[100];
        reader = ALasReader.getReader((File)lasFile, (CoordinateReferenceSystem)crs);
        reader.setOverrideGpsTimeType(timeType);
        ILasHeader header2 = reader.getHeader();
        while (reader.hasNextPoint()) {
            LasRecord readNextLasDot = reader.getNextPoint();
            long dateSeconds = this.getDateSeconds(gpsTimeType, readNextLasDot);
            for (int j = 0; j < markersArray.length; ++j) {
                if (dateSeconds > markersArray[j]) continue;
                if (writers[j] == null) {
                    File file = new File(outFolderFile, nameWithoutExtention + "_" + j + ".las");
                    writers[j] = ALasWriter.getWriter((File)file, (CoordinateReferenceSystem)crs);
                    writers[j].setBounds(header2);
                    writers[j].open();
                }
                writers[j].addPoint(readNextLasDot);
                break;
            }
            this.pm.worked(1);
        }
        reader.close();
        this.pm.done();
        for (int j = 0; j < writers.length; ++j) {
            ALasWriter writer = writers[j];
            if (writer == null) continue;
            writer.close();
        }
        if (this.doPlot) {
            String[] catStr = new String[cat.length];
            for (int j = 0; j < cat.length; ++j) {
                catStr[j] = String.valueOf(cat[j]);
            }
            CategoryHistogram hi = new CategoryHistogram(catStr, values);
            PlotFrame frame = new PlotFrame((IChart)hi);
            frame.plot();
        }
    }

    private long getDateSeconds(int gpsTimeType, LasRecord readNextLasDot) {
        long dateSeconds;
        if (gpsTimeType == 0) {
            DateTime dt = GpsTimeConverter.gpsWeekTime2DateTime((double)readNextLasDot.gpsTime);
            dateSeconds = dt.getMillis() / 1000L;
        } else {
            DateTime gpsTimeToDateTime = LasUtils.adjustedStandardGpsTime2DateTime((double)readNextLasDot.gpsTime);
            dateSeconds = gpsTimeToDateTime.getMillis() / 1000L;
        }
        return dateSeconds;
    }

    public static void main(String[] args) throws Exception {
        Files.list(Paths.get("/media/hydrologis/LATEMAR/lavori_tmp/2016_10_geologico/test_flightlines/57_Class_LAS/", new String[0])).filter(p -> p.getFileName().toString().endsWith(".las")).forEach(path -> {
            FlightLinesExtractor eh = new FlightLinesExtractor();
            eh.inLas = path.toString();
            eh.doPlot = false;
            eh.pGpsTimeType = WEEK_SECONDS_TIME;
            eh.outFolder = "/media/hydrologis/LATEMAR/lavori_tmp/2016_10_geologico/test_flightlines/57_Class_LAS/flightlines";
            try {
                eh.process();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }
}

