/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.lesto.modules.utilities;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import oms3.annotations.Unit;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope3D;
import org.hortonmachine.gears.io.las.core.ALasReader;
import org.hortonmachine.gears.io.las.core.ILasHeader;
import org.hortonmachine.gears.io.las.core.LasRecord;
import org.hortonmachine.gears.libs.exceptions.ModelsIllegalargumentException;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.utils.geometry.GeometryUtilities;
import org.hortonmachine.gears.utils.math.NumericsUtilities;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.index.strtree.STRtree;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Description(value="Creates a vector map of the point cloud density over a given grid.")
@Author(name="Andrea Antonello, Silvia Franceschi", contact="www.hydrologis.com")
@Keywords(value="las, density, vector")
@Label(value="Lesto/utilities")
@Name(value="laspointdensityextractor")
@Status(value=10)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class LasPointDensityExtractor
extends HMModel {
    @Description(value="Las file path.")
    @UI(value="infile_las")
    @In
    public String inFile;
    @Description(value="The grid resolution.")
    @Unit(value="m")
    @In
    public double pGridStep = 1.0;
    @Description(value="Output vector map.")
    @UI(value="outfile")
    @In
    public String outFile;
    private CoordinateReferenceSystem crs;

    @Execute
    public void process() throws Exception {
        this.checkNull(new Object[]{this.inFile});
        if (this.pGridStep <= 0.0) {
            throw new ModelsIllegalargumentException("The grid step has to be major than 0.", (Object)this);
        }
        ArrayList<DensityData> densityDataList = new ArrayList<DensityData>();
        File lasFile = new File(this.inFile);
        try (ALasReader lasReader = ALasReader.getReader((File)lasFile, null);){
            DensityData densityData;
            lasReader.open();
            ILasHeader header = lasReader.getHeader();
            this.crs = header.getCrs();
            ReferencedEnvelope3D dataEnvelope = header.getDataEnvelope();
            double[] xBins = NumericsUtilities.range2Bins((double)dataEnvelope.getMinX(), (double)dataEnvelope.getMaxX(), (double)this.pGridStep, (boolean)false);
            double[] yBins = NumericsUtilities.range2Bins((double)dataEnvelope.getMinY(), (double)dataEnvelope.getMaxY(), (double)this.pGridStep, (boolean)false);
            STRtree tree = new STRtree();
            for (int x = 0; x < xBins.length - 1; ++x) {
                double minX = xBins[x];
                double maxX = xBins[x + 1];
                for (int y = 0; y < yBins.length - 1; ++y) {
                    double minY = yBins[y];
                    double maxY = yBins[y + 1];
                    Envelope envelope = new Envelope(minX, maxX, minY, maxY);
                    densityData = new DensityData();
                    tree.insert(envelope, (Object)densityData);
                    densityDataList.add(densityData);
                    Polygon polygon = GeometryUtilities.createPolygonFromEnvelope((Envelope)envelope);
                    densityData.geometry = polygon;
                }
            }
            long recordsCount = header.getRecordsCount();
            this.pm.beginTask("Sorting las data...", (int)recordsCount);
            while (lasReader.hasNextPoint()) {
                this.pm.worked(1);
                LasRecord lasDot = lasReader.getNextPoint();
                double x = lasDot.x;
                double y = lasDot.y;
                short impulse = lasDot.returnNumber;
                Coordinate p = new Coordinate(x, y);
                Envelope envelope = new Envelope(p);
                List result = tree.query(envelope);
                if (result.size() < 1) {
                    throw new RuntimeException();
                }
                densityData = null;
                if (result.size() == 1) {
                    densityData = (DensityData)result.get(0);
                } else {
                    for (Object object : result) {
                        densityData = (DensityData)object;
                        Point point = this.gf.createPoint(p);
                        if (!densityData.geometry.intersects((Geometry)point)) continue;
                        break;
                    }
                }
                short s = impulse;
                densityData.imp[s] = densityData.imp[s] + 1;
                densityData.imp[0] = densityData.imp[0] + 1;
            }
            this.pm.done();
        }
        DefaultFeatureCollection outGeodata = new DefaultFeatureCollection();
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.setName("lasdata");
        b.setCRS(this.crs);
        b.add("the_geom", Polygon.class);
        b.add("imp1", Integer.class);
        b.add("imp2", Integer.class);
        b.add("imp3", Integer.class);
        b.add("imp4", Integer.class);
        b.add("imp5", Integer.class);
        b.add("total", Integer.class);
        SimpleFeatureType type = b.buildFeatureType();
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(type);
        for (DensityData d : densityDataList) {
            Object[] objs = new Object[]{d.geometry, d.imp[1], d.imp[2], d.imp[3], d.imp[4], d.imp[5], d.imp[0]};
            if (d.imp[0] <= 0) continue;
            builder.addAll(objs);
            SimpleFeature feature = builder.buildFeature(null);
            outGeodata.add(feature);
        }
        this.dumpVector((SimpleFeatureCollection)outGeodata, this.outFile);
    }

    private static class DensityData {
        int[] imp = new int[6];
        Geometry geometry;

        private DensityData() {
        }
    }
}

