/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.lesto.modules.vegetation;

import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import javax.media.jai.iterator.RandomIter;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import oms3.annotations.Unit;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.hortonmachine.gears.libs.modules.GridNode;
import org.hortonmachine.gears.libs.modules.GridNodePositionComparator;
import org.hortonmachine.gears.libs.modules.HMConstants;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.libs.monitor.DummyProgressMonitor;
import org.hortonmachine.gears.modules.r.rasterdiff.OmsRasterDiff;
import org.hortonmachine.gears.utils.RegionMap;
import org.hortonmachine.gears.utils.coverage.CoverageUtilities;
import org.hortonmachine.hmachine.modules.geomorphology.geomorphon.GeomorphonClassification;
import org.hortonmachine.hmachine.modules.geomorphology.geomorphon.OmsGeomorphon;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

@Description(value="The Geomorphon method to extract maxima from rasters")
@Author(name="Andrea Antonello, Silvia Franceschi", contact="www.hydrologis.com")
@Keywords(value="raster, maxima, geomorphon")
@Label(value="Lesto/vegetation")
@Name(value="_geomorphonmaximafinder")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class OmsGeomorphonMaximaFinder
extends HMModel {
    @Description(value="The DTM.")
    @In
    public GridCoverage2D inDTM;
    @Description(value="The DSM.")
    @In
    public GridCoverage2D inDSM;
    @Description(value="Maximum search radius")
    @Unit(value="m")
    @In
    public double pRadius;
    @Description(value="Vertical angle threshold.")
    @Unit(value="degree")
    @In
    public double pThreshold = 1.0;
    @Description(value="Elevation difference threshold.")
    @Unit(value="m")
    @In
    public double pElevDiffThres = 1.0;
    @Description(value="Extracted maxima.")
    @Out
    public SimpleFeatureCollection outMaxima;
    public static final String LABEL = "Lesto/vegetation";
    public static final String LICENSE = "General Public License Version 3 (GPLv3)";
    public static final int STATUS = 5;
    public static final String NAME = "geomorphonmaximafinder";
    public static final String KEYWORDS = "raster, maxima, geomorphon";
    public static final String CONTACTS = "www.hydrologis.com";
    public static final String AUTHORS = "Andrea Antonello, Silvia Franceschi";
    public static final String DESCRIPTION = "The Geomorphon method to extract maxima from rasters";
    public static final String outMaxima_DESC = "Extracted maxima.";
    public static final String pElevDiff_DESC = "Elevation difference threshold.";
    public static final String pThreshold_DESC = "Vertical angle threshold.";
    public static final String pRadius_DESC = "Maximum search radius";
    public static final String inDSM_DESC = "The DSM.";
    public static final String inDTM_DESC = "The DTM.";
    public static final String pThreshold_UNIT = "degree";
    public static final String pRadius_UNIT = "m";
    public static final String pElevDiffThres_UNIT = "m";
    private int peakCode;
    private int hollowCode;
    private int valleyCode;
    private int pitCode;
    private int spurCode;

    @Execute
    public void process() throws Exception {
        this.checkNull(new Object[]{this.inDTM, this.inDSM});
        GridGeometry2D gridGeometry = this.inDSM.getGridGeometry();
        DummyProgressMonitor pm = new DummyProgressMonitor();
        OmsGeomorphon g = new OmsGeomorphon();
        g.pm = pm;
        g.inElev = this.inDSM;
        g.pRadius = this.pRadius;
        g.pThreshold = this.pThreshold;
        g.process();
        GridCoverage2D geomorphonGC = g.outRaster;
        OmsRasterDiff rasterDiff = new OmsRasterDiff();
        rasterDiff.inRaster1 = this.inDSM;
        rasterDiff.inRaster2 = this.inDTM;
        rasterDiff.pm = pm;
        rasterDiff.process();
        GridCoverage2D dsmDtmThresDiff = rasterDiff.outRaster;
        RegionMap regionMap = CoverageUtilities.getRegionParamsFromGridCoverage((GridCoverage2D)this.inDSM);
        int rows = regionMap.getRows();
        int cols = regionMap.getCols();
        TreeSet<GridNode> topNodes = new TreeSet<GridNode>((Comparator<GridNode>)new GridNodePositionComparator());
        this.peakCode = GeomorphonClassification.PEAK.getCode();
        this.hollowCode = GeomorphonClassification.HOLLOW.getCode();
        this.valleyCode = GeomorphonClassification.VALLEY.getCode();
        this.pitCode = GeomorphonClassification.PIT.getCode();
        this.spurCode = GeomorphonClassification.SPUR.getCode();
        RandomIter geomorphIter = CoverageUtilities.getRandomIterator((GridCoverage2D)geomorphonGC);
        RandomIter elevIter = CoverageUtilities.getRandomIterator((GridCoverage2D)dsmDtmThresDiff);
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                GridNode topNode;
                GridNode geomorphNode = new GridNode(geomorphIter, cols, rows, 1.0, -1.0, c, r);
                GridNode elevNode = new GridNode(elevIter, cols, rows, 1.0, -1.0, c, r);
                if (geomorphNode.elevation != (double)this.peakCode || elevNode.touchesBound()) continue;
                boolean isLocalMaxima = true;
                TreeSet<GridNode> peakNodes = new TreeSet<GridNode>((Comparator<GridNode>)new GridNodePositionComparator());
                peakNodes.add(geomorphNode);
                this.gatherNodes(peakNodes, geomorphNode);
                if (peakNodes.size() == 1) {
                    topNode = peakNodes.first();
                    GridNode topElevNode = new GridNode(elevIter, cols, rows, 1.0, -1.0, topNode.col, topNode.row);
                    List validSurroundingNodes = topElevNode.getValidSurroundingNodes();
                    if (validSurroundingNodes.size() < 6) {
                        isLocalMaxima = false;
                    } else if (!this.analyzeNeighbors(topNode)) {
                        isLocalMaxima = false;
                    }
                }
                topNode = null;
                if (isLocalMaxima) {
                    double maxElev = Double.NEGATIVE_INFINITY;
                    for (GridNode peakNode : peakNodes) {
                        double elev = peakNode.getValueFromMap(elevIter);
                        if (!(elev > maxElev)) continue;
                        maxElev = elev;
                        topNode = peakNode;
                    }
                    if (topNode != null) {
                        GridNode topElevNode = new GridNode(elevIter, cols, rows, 1.0, -1.0, topNode.col, topNode.row);
                        double[][] windowValues = topElevNode.getWindow(3, false);
                        double min = Double.POSITIVE_INFINITY;
                        double max = Double.NEGATIVE_INFINITY;
                        double[][] dArray = windowValues;
                        int n = dArray.length;
                        for (int i = 0; i < n; ++i) {
                            double[] windowRow;
                            for (double windowValue : windowRow = dArray[i]) {
                                if (HMConstants.isNovalue((double)windowValue)) {
                                    isLocalMaxima = false;
                                    break;
                                }
                                min = Math.min(min, windowValue);
                                max = Math.max(max, windowValue);
                            }
                            if (!isLocalMaxima) break;
                        }
                        if (max - min > this.pElevDiffThres) {
                            isLocalMaxima = false;
                        }
                    }
                }
                if (!isLocalMaxima || topNode == null) continue;
                topNodes.add(topNode);
            }
        }
        this.outMaxima = new DefaultFeatureCollection();
        SimpleFeatureBuilder builder = this.getOutBuilder();
        int id = 0;
        for (GridNode topNode : topNodes) {
            Coordinate coordinate = CoverageUtilities.coordinateFromColRow((int)topNode.col, (int)topNode.row, (GridGeometry2D)gridGeometry);
            Point point = this.gf.createPoint(coordinate);
            double elev = topNode.getValueFromMap(elevIter);
            Object[] values = new Object[]{point, id++, elev};
            try {
                builder.addAll(values);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            SimpleFeature newFeature = builder.buildFeature(null);
            ((DefaultFeatureCollection)this.outMaxima).add(newFeature);
        }
        geomorphIter.done();
        elevIter.done();
        int size = this.outMaxima.size();
        if (size == 0) {
            pm.message("No tops extracted...");
        } else {
            pm.message("Extracted tops =  " + this.outMaxima.size());
        }
    }

    private void gatherNodes(TreeSet<GridNode> peakNodes, GridNode node) {
        List surroundingNodes = node.getValidSurroundingNodes();
        for (GridNode surrNode : surroundingNodes) {
            if (surrNode.elevation != (double)this.peakCode || !peakNodes.add(surrNode)) continue;
            this.gatherNodes(peakNodes, surrNode);
        }
    }

    private boolean analyzeNeighbors(GridNode topNode) {
        double[][] window = topNode.getWindow(3, false);
        int counthollow = 0;
        int countvalley = 0;
        int countpit = 0;
        int countspur = 0;
        for (int winRow = 0; winRow < window.length; ++winRow) {
            for (int winCol = 0; winCol < window[0].length; ++winCol) {
                double value = window[winRow][winCol];
                if (HMConstants.isNovalue((double)value)) continue;
                if (value == (double)this.hollowCode) {
                    ++counthollow;
                    continue;
                }
                if (value == (double)this.valleyCode) {
                    ++countvalley;
                    continue;
                }
                if (value == (double)this.pitCode) {
                    ++countpit;
                    continue;
                }
                if (value != (double)this.spurCode) continue;
                ++countspur;
            }
        }
        if (countpit > 0 && countvalley > 0) {
            return false;
        }
        return countpit <= 0 || countvalley <= 0 || countspur <= 0 || counthollow <= 0;
    }

    private SimpleFeatureBuilder getOutBuilder() {
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.setName("geomorphon");
        b.setCRS(this.inDSM.getCoordinateReferenceSystem());
        b.add("the_geom", Point.class);
        b.add("id", String.class);
        b.add("elev", Double.class);
        SimpleFeatureType type = b.buildFeatureType();
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(type);
        return builder;
    }
}

