/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.lesto.modules.vegetation;

import java.awt.image.WritableRaster;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import org.geotools.coverage.grid.GridCoordinates2D;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope3D;
import org.hortonmachine.gears.io.las.core.ALasReader;
import org.hortonmachine.gears.io.las.core.LasRecord;
import org.hortonmachine.gears.io.rasterwriter.OmsRasterWriter;
import org.hortonmachine.gears.libs.modules.HMConstants;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.utils.RegionMap;
import org.hortonmachine.gears.utils.coverage.CoverageUtilities;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Description(value="Module that identifies local maxima in point clouds.")
@Author(name="Andrea Antonello, Silvia Franceschi", contact="www.hydrologis.com")
@Keywords(value="Local maxima, las, lidar")
@Label(value="Lesto/vegetation")
@Name(value="_pointcloudmaximafinder_stream")
@Status(value=10)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class OmsPointCloudMaximaFinderStream
extends HMModel {
    @Description(value="The input las.")
    @In
    public List<LasRecord> inLas = null;
    @In
    @Description(value="The requested are aof interest bounds.")
    public ReferencedEnvelope aoi;
    @Description(value="The base grid resolution.")
    @In
    public double pBaseGridResolution = 0.5;
    @Description(value="Radius for which a point can be local maxima.")
    @In
    public double pMaxRadius = -1.0;
    @Description(value="The output local maxima.")
    @In
    public GridCoverage2D outCoverage = null;
    public static final String outTops_DESCR = "The output local maxima.";
    public static final String pClass_DESCR = "The comma separated list of classes to filter (if empty, all are picked).";
    public static final String pThreshold_DESCR = "The elevation threshold to apply to the chm.";
    public static final String pElevDiffThres_DESCR = "Max permitted elevation difference around the maxima.";
    public static final String doDynamicRadius_DESCR = "Use an adaptive radius based on the height.";
    public static final String pMaxRadius_DESCR = "Radius for which a point can be local maxima.";
    public static final String inDsmDtmDiff_DESCR = "An optional dsm-dtm difference raster to use to check on the extracted tops.";
    public static final String inRoi_DESCR = "A set of polygons to use as region of interest.";
    public static final String inDtm_DESCR = "A dtm raster to use for the area of interest and to calculate the elevation threshold.";
    public static final String inLas_DESCR = "The input las.";
    public static final String NAME = "pointcloudmaximafinder";
    public static final String KEYWORDS = "Local maxima, las, lidar";
    public static final String DESCR = "Module that identifies local maxima in point clouds.";
    public static final String LABEL = "Lesto/vegetation";

    @Execute
    public void process() throws Exception {
        this.checkNull(new Object[]{this.inLas, this.aoi});
        CoordinateReferenceSystem crs = this.aoi.getCoordinateReferenceSystem();
        double north = this.aoi.getMaxY();
        double south = this.aoi.getMinY();
        double east = this.aoi.getMaxX();
        double west = this.aoi.getMinX();
        int cols = (int)Math.round((east - west) / this.pBaseGridResolution);
        int rows = (int)Math.round((north - south) / this.pBaseGridResolution);
        GridGeometry2D gridGeometry = CoverageUtilities.gridGeometryFromRegionValues((double)north, (double)south, (double)east, (double)west, (int)cols, (int)rows, (CoordinateReferenceSystem)crs);
        WritableRaster outWR = CoverageUtilities.createWritableRaster((int)cols, (int)rows, null, null, (Object)-9999.0);
        this.pm.beginTask("Distribute maximum values on grid...", this.inLas.size());
        for (LasRecord dot : this.inLas) {
            DirectPosition2D wPoint = new DirectPosition2D(dot.x, dot.y);
            if (!this.aoi.contains((DirectPosition)wPoint)) continue;
            GridCoordinates2D gridCoord = gridGeometry.worldToGrid((DirectPosition)wPoint);
            int x = gridCoord.x;
            int y = gridCoord.y;
            double value = outWR.getSampleDouble(x, y, 0);
            value = HMConstants.isNovalue((double)value) ? dot.z : Math.max(dot.z, value);
            outWR.setSample(x, y, 0, value);
            this.pm.worked(1);
        }
        this.pm.done();
        int rowPerRadius = (int)Math.ceil(this.pMaxRadius / this.pBaseGridResolution);
        this.pm.beginTask("Grow maxima regions...", rows);
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                double centerValue = outWR.getSampleDouble(c, r, 0);
                if (HMConstants.isNovalue((double)centerValue)) continue;
                for (int wc = c - rowPerRadius; wc <= c + rowPerRadius; ++wc) {
                    for (int wr = r - rowPerRadius; wr <= r + rowPerRadius; ++wr) {
                        double wValue;
                        if (wr == r && wc == c || wr < 0 || wr >= rows || wc < 0 || wc >= cols || HMConstants.isNovalue((double)(wValue = outWR.getSampleDouble(wc, wr, 0)))) continue;
                        double newValue = Math.max(centerValue, wValue);
                        outWR.setSample(wc, wr, 0, newValue);
                    }
                }
            }
            this.pm.worked(1);
        }
        this.pm.done();
        RegionMap regionMap = CoverageUtilities.gridGeometry2RegionParamsMap((GridGeometry2D)gridGeometry);
        this.outCoverage = CoverageUtilities.buildCoverage((String)"tops", (WritableRaster)outWR, (HashMap)regionMap, (CoordinateReferenceSystem)crs);
    }

    public static void main(String[] args) throws Exception {
        String lasPath = "/media/hydrologis/LESTOPLUS/test_lidar_spatialite/las_aurina/uni_bz_44.las";
        String outPath = "/home/hydrologis/TMP/tops_2m.asc";
        OmsPointCloudMaximaFinderStream s = new OmsPointCloudMaximaFinderStream();
        ArrayList<LasRecord> dotList = new ArrayList<LasRecord>();
        try (ALasReader reader = ALasReader.getReader((File)new File(lasPath), null);){
            reader.open();
            while (reader.hasNextPoint()) {
                LasRecord dot = reader.getNextPoint();
                dotList.add(dot);
            }
            s.inLas = dotList;
            ReferencedEnvelope3D dataEnvelope = reader.getHeader().getDataEnvelope();
            s.aoi = new ReferencedEnvelope((ReferencedEnvelope)dataEnvelope);
            s.pBaseGridResolution = 0.5;
            s.pMaxRadius = 2.0;
            s.process();
            OmsRasterWriter.writeRaster((String)outPath, (GridCoverage2D)s.outCoverage);
        }
    }
}

