/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.lesto.modules.vegetation;

import java.awt.image.WritableRaster;
import java.util.HashMap;
import java.util.List;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;
import javax.media.jai.iterator.WritableRandomIter;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import oms3.annotations.Unit;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.hortonmachine.gears.libs.modules.GridNode;
import org.hortonmachine.gears.libs.modules.HMConstants;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.utils.RegionMap;
import org.hortonmachine.gears.utils.coverage.CoverageUtilities;
import org.hortonmachine.gears.utils.features.FeatureUtilities;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Description(value="A region growing module")
@Author(name="Andrea Antonello, Silvia Franceschi", contact="www.hydrologis.com")
@Keywords(value="region growing, raster")
@Label(value="Lesto/vegetation")
@Name(value="regiongrowing")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class RegionGrowing
extends HMModel {
    @Description(value="The vector of maxima points")
    @UI(value="infile_vector")
    @In
    public String inMaxima;
    @Description(value="The dsm raster")
    @UI(value="infile_raster")
    @In
    public String inDsm;
    @Description(value="The dtm raster. If not supplied it will be put to a plane placed in 0.")
    @UI(value="infile_raster")
    @In
    public String inDtm;
    @Description(value="The maximum crown radius.")
    @Unit(value="m")
    @In
    public double pRadius = 5.0;
    @Description(value="The minimum tree height considered.")
    @Unit(value="m")
    @In
    public double pHeight = 5.0;
    @Description(value="The minimum height percentage considered from the top.")
    @Unit(value="%")
    @In
    public double pPtop = 75.0;
    @Description(value="Use the elevation to index instead of a sequence.")
    @In
    public boolean doElev = false;
    @Description(value="The regions raster")
    @UI(value="outfile")
    @In
    public String outRaster;
    private WritableRandomIter outIter;

    public void process() throws Exception {
        RandomIter dtmIter;
        this.checkNull(new Object[]{this.inMaxima, this.inDsm, this.outRaster});
        GridCoverage2D inDsmGC = this.getRaster(this.inDsm);
        RegionMap regionMap = CoverageUtilities.getRegionParamsFromGridCoverage((GridCoverage2D)inDsmGC);
        int cols = regionMap.getCols();
        int rows = regionMap.getRows();
        double xRes = regionMap.getXres();
        double yRes = regionMap.getYres();
        GridGeometry2D gridGeometry = inDsmGC.getGridGeometry();
        RandomIter dsmIter = CoverageUtilities.getRandomIterator((GridCoverage2D)inDsmGC);
        if (this.inDtm != null) {
            GridCoverage2D inDtmGC = this.getRaster(this.inDtm);
            dtmIter = CoverageUtilities.getRandomIterator((GridCoverage2D)inDtmGC);
        } else {
            WritableRaster dtmWR = CoverageUtilities.createWritableRaster((int)cols, (int)rows, null, null, (Object)0.0);
            dtmIter = RandomIterFactory.createWritable((WritableRaster)dtmWR, null);
        }
        WritableRaster outWR = CoverageUtilities.createWritableRaster((int)cols, (int)rows, null, null, (Object)-9999.0);
        this.outIter = RandomIterFactory.createWritable((WritableRaster)outWR, null);
        SimpleFeatureCollection inMaximaFC = this.getVector(this.inMaxima);
        List maximaList = FeatureUtilities.featureCollectionToList((SimpleFeatureCollection)inMaximaFC);
        this.pm.beginTask("Processing region growing...", maximaList.size());
        int index = 0;
        for (SimpleFeature maximaFeature : maximaList) {
            Coordinate coordinate = ((Geometry)maximaFeature.getDefaultGeometry()).getCoordinate();
            int[] colRow = CoverageUtilities.colRowFromCoordinate((Coordinate)coordinate, (GridGeometry2D)gridGeometry, null);
            GridNode startDsmNode = new GridNode(dsmIter, cols, rows, xRes, yRes, colRow[0], colRow[1]);
            GridNode startDtmNode = new GridNode(dtmIter, cols, rows, xRes, yRes, colRow[0], colRow[1]);
            this.growRegion(startDsmNode, startDtmNode, index, startDsmNode, startDtmNode);
            ++index;
            this.pm.worked(1);
        }
        this.pm.done();
        dtmIter.done();
        this.outIter.done();
        GridCoverage2D outRasterGC = CoverageUtilities.buildCoverage((String)"filtered", (WritableRaster)outWR, (HashMap)regionMap, (CoordinateReferenceSystem)inDsmGC.getCoordinateReferenceSystem());
        this.dumpRaster(outRasterGC, this.outRaster);
    }

    private void growRegion(GridNode topDsmNode, GridNode topDtmNode, int index, GridNode dsmNode, GridNode dtmNode) {
        if (dsmNode.isValid() && dtmNode.isValid()) {
            double topDsmElevation = topDsmNode.elevation;
            double topDtmElevation = topDtmNode.elevation;
            if (this.doElev) {
                dsmNode.setDoubleValueInMap(this.outIter, topDsmElevation);
            } else {
                dsmNode.setValueInMap(this.outIter, (double)index);
            }
            double currentDsmElevation = dsmNode.elevation;
            List surroundingDsmNodes = dsmNode.getSurroundingNodes();
            List surroundingDtmNodes = dtmNode.getSurroundingNodes();
            for (int k = 0; k < surroundingDsmNodes.size(); ++k) {
                double deltaElevation;
                int row;
                int col;
                double outValue;
                GridNode surroundingDsmNode = (GridNode)surroundingDsmNodes.get(k);
                GridNode surroundingDtmNode = (GridNode)surroundingDtmNodes.get(k);
                if (surroundingDsmNode == null || surroundingDtmNode == null || !surroundingDsmNode.isValid() || !surroundingDtmNode.isValid() || !HMConstants.isNovalue((double)(outValue = this.outIter.getSampleDouble(col = surroundingDsmNode.col, row = surroundingDsmNode.row, 0)))) continue;
                double surroundingDsmElevation = surroundingDsmNode.elevation;
                double surroundingDtmElevation = surroundingDtmNode.elevation;
                if (!(surroundingDsmElevation < currentDsmElevation) || (deltaElevation = surroundingDsmElevation - surroundingDtmElevation) < this.pHeight || deltaElevation < this.pPtop / 100.0 * (topDsmElevation - topDtmElevation) || topDsmNode.getDistance(surroundingDsmNode) > this.pRadius) continue;
                if (this.doElev) {
                    surroundingDsmNode.setDoubleValueInMap(this.outIter, topDsmElevation);
                } else {
                    surroundingDsmNode.setValueInMap(this.outIter, (double)index);
                }
                this.growRegion(topDsmNode, topDtmNode, index, surroundingDsmNode, surroundingDtmNode);
            }
        }
    }
}

