/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.lesto.modules.raster;

import java.awt.Point;
import java.awt.image.WritableRaster;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.media.jai.iterator.WritableRandomIter;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import oms3.annotations.Unit;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RRQRDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.linear.SingularMatrixException;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.styling.Style;
import org.hortonmachine.gears.io.las.ALasDataManager;
import org.hortonmachine.gears.io.las.core.LasRecord;
import org.hortonmachine.gears.libs.exceptions.ModelsIllegalargumentException;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.libs.modules.ThreadedRunnable;
import org.hortonmachine.gears.modules.r.imagemosaic.OmsImageMosaicCreator;
import org.hortonmachine.gears.utils.RegionMap;
import org.hortonmachine.gears.utils.colors.EColorTables;
import org.hortonmachine.gears.utils.colors.RasterStyleUtilities;
import org.hortonmachine.gears.utils.coverage.CoverageUtilities;
import org.hortonmachine.gears.utils.files.FileUtilities;
import org.hortonmachine.gears.utils.geometry.GeometryUtilities;
import org.hortonmachine.gears.utils.math.NumericsUtilities;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Description(value="Module that converts a las data into a set of mosaic rasters using a bivariate function.")
@Author(name="Andrea Antonello, Silvia Franceschi", contact="www.hydrologis.com")
@Keywords(value="las, lidar, raster, bivariate, mosaic")
@Label(value="Lesto/raster")
@Name(value="lasfolder2bivariaterastermosaic")
@Status(value=10)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class Las2BivariateRasterMosaic
extends HMModel {
    @Description(value="Las files folder main index file path.")
    @UI(value="infile_las")
    @In
    public String inLas = null;
    @Description(value="A region of interest. If not supplied the whole dataset is used.")
    @UI(value="infile_vector")
    @In
    public String inRoi;
    @Description(value="The tilesize of the subrasters.")
    @Unit(value="m")
    @In
    public double pTilesize = 5000.0;
    @Description(value="New resolution used for the tiles.")
    @Unit(value="m")
    @In
    public double pRes = 1.0;
    @Description(value="Buffer of influence for points interpolation in number of cells.")
    @In
    public int pBuffer = 2;
    @Description(value="The impulse to use (if empty everything is used).")
    @In
    public Integer pImpulse = 1;
    @Description(value="Number of threads to use.")
    @In
    public int pThreads = 1;
    @Description(value="If true, intensity is used instead of elevation.")
    @In
    public boolean doIntensity = false;
    @Description(value="Minimum number of points to consider the resulting cell valid.")
    @In
    public int pMinpoints = 6;
    @Description(value="The output folder.")
    @UI(value="outfile")
    @In
    public String outFolder = null;
    private static final double NOINTENSITY = -9999.0;
    private volatile double minValue = Double.POSITIVE_INFINITY;
    private volatile double maxValue = Double.NEGATIVE_INFINITY;
    private CoordinateReferenceSystem crs;

    @Execute
    public void process() throws Exception {
        this.checkNull(new Object[]{this.inLas, this.outFolder});
        final File outFolderFile = new File(this.outFolder);
        try (final ALasDataManager lasData = ALasDataManager.getDataManager((File)new File(this.inLas), null, (double)0.0, null);){
            lasData.open();
            if (this.pImpulse != null) {
                lasData.setImpulsesConstraint(new double[]{this.pImpulse.intValue()});
            }
            ReferencedEnvelope roiEnvelope = lasData.getOverallEnvelope();
            this.crs = roiEnvelope.getCoordinateReferenceSystem();
            if (this.crs == null && this.inRoi == null) {
                throw new ModelsIllegalargumentException("The lasfolder file needs to have a prj definition.", (Object)this);
            }
            if (this.inRoi != null) {
                SimpleFeatureCollection inRoiFC = this.getVector(this.inRoi);
                roiEnvelope = inRoiFC.getBounds();
            }
            double overallW = roiEnvelope.getMinX();
            double overallE = roiEnvelope.getMaxX();
            double overallS = roiEnvelope.getMinY();
            double overallN = roiEnvelope.getMaxY();
            double[] xBins = NumericsUtilities.range2Bins((double)overallW, (double)overallE, (double)this.pTilesize, (boolean)true);
            double[] yBins = NumericsUtilities.range2Bins((double)overallS, (double)overallN, (double)this.pTilesize, (boolean)true);
            int tilesCols = xBins.length - 1;
            int tilesRows = yBins.length - 1;
            this.pm.message("Splitting into tiles: " + tilesCols + " x " + tilesRows);
            this.pm.beginTask("Interpolating tiles...", tilesCols * tilesRows);
            ThreadedRunnable runnable = null;
            if (this.pThreads > 1) {
                runnable = new ThreadedRunnable(this.pThreads, this.pm);
            }
            for (int x = 0; x < xBins.length - 1; ++x) {
                for (int y = 0; y < yBins.length - 1; ++y) {
                    final double w = xBins[x];
                    final double e = xBins[x + 1];
                    final double s = yBins[y];
                    final double n = yBins[y + 1];
                    final int _x = x;
                    final int _y = y;
                    if (runnable != null) {
                        runnable.executeRunnable(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    Las2BivariateRasterMosaic.this.processTile(outFolderFile, Las2BivariateRasterMosaic.this.crs, lasData, _x, _y, w, e, s, n);
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                                Las2BivariateRasterMosaic.this.pm.worked(1);
                            }
                        });
                        continue;
                    }
                    try {
                        this.processTile(outFolderFile, this.crs, lasData, _x, _y, w, e, s, n);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    this.pm.worked(1);
                }
            }
            if (runnable != null) {
                runnable.waitAndClose();
            }
            this.pm.done();
        }
        OmsImageMosaicCreator im = new OmsImageMosaicCreator();
        im.inFolder = this.outFolder;
        im.process();
        String name = outFolderFile.getName();
        String style = RasterStyleUtilities.styleToString((Style)RasterStyleUtilities.createStyleForColortable((String)EColorTables.extrainbow.name(), (double)this.minValue, (double)this.maxValue, null, (double)1.0));
        File styleFile = new File(outFolderFile, name + ".sld");
        FileUtilities.writeFile((String)style, (File)styleFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTile(File outFolderFile, CoordinateReferenceSystem crs, ALasDataManager lasData, int x, int y, double w, double e, double s, double n) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("tile_");
        sb.append(x);
        sb.append("_");
        sb.append(y);
        String tileName = sb.toString();
        sb.append(".tiff");
        File outTileFile = new File(outFolderFile, sb.toString());
        if (outTileFile.exists()) {
            this.pm.errorMessage("Not overwriting existing tile: " + outTileFile.getName());
            return;
        }
        int cols = (int)Math.round((e - w) / this.pRes);
        int rows = (int)Math.round((n - s) / this.pRes);
        double xRes = (e - w) / (double)cols;
        double yRes = (n - s) / (double)rows;
        RegionMap regionMap = CoverageUtilities.makeRegionParamsMap((double)n, (double)s, (double)w, (double)e, (double)xRes, (double)yRes, (int)cols, (int)rows);
        WritableRaster outWR = CoverageUtilities.createWritableRaster((int)cols, (int)rows, null, null, (Object)-9999.0);
        GridCoverage2D outputCoverage = CoverageUtilities.buildCoverage((String)"data", (WritableRaster)outWR, (HashMap)regionMap, (CoordinateReferenceSystem)crs);
        Envelope env = new Envelope(w, e, s, n);
        double deltaX = xRes * (double)this.pBuffer;
        double deltaY = yRes * (double)this.pBuffer;
        env.expandBy(deltaX, deltaY);
        Polygon roiPolygon = GeometryUtilities.createPolygonFromEnvelope((Envelope)env);
        List tileLasPoints = lasData.getPointsInGeometry((Geometry)roiPolygon, true);
        if (tileLasPoints.size() > 100) {
            GridGeometry2D gridGeometry = outputCoverage.getGridGeometry();
            int newCols = cols + 2 * this.pBuffer;
            int newRows = rows + 2 * this.pBuffer;
            GridGeometry2D bufferedGridGeometry = CoverageUtilities.gridGeometryFromRegionValues((double)env.getMaxY(), (double)env.getMinY(), (double)env.getMaxX(), (double)env.getMinX(), (int)newCols, (int)newRows, (CoordinateReferenceSystem)crs);
            ArrayList[][] lasMatrix = new ArrayList[newCols][newRows];
            for (int r = 0; r < newRows; ++r) {
                for (int c = 0; c < newCols; ++c) {
                    ArrayList item;
                    lasMatrix[c][r] = item = new ArrayList();
                }
            }
            Point point = new Point();
            for (LasRecord dot : tileLasPoints) {
                if (this.doIntensity) {
                    if ((double)dot.intensity == -9999.0) continue;
                    this.minValue = Math.min((double)dot.intensity, this.minValue);
                    this.maxValue = Math.max((double)dot.intensity, this.maxValue);
                } else {
                    this.minValue = Math.min(dot.z, this.minValue);
                    this.maxValue = Math.max(dot.z, this.maxValue);
                }
                CoverageUtilities.colRowFromCoordinate((Coordinate)new Coordinate(dot.x, dot.y), (GridGeometry2D)bufferedGridGeometry, (Point)point);
                lasMatrix[point.x][point.y].add(dot);
            }
            WritableRandomIter outWIter = null;
            try {
                outWIter = CoverageUtilities.getWritableRandomIterator((WritableRaster)outWR);
                for (int c = this.pBuffer; c < newCols - this.pBuffer; ++c) {
                    if (c % 100 == 0) {
                        StringBuilder sb1 = new StringBuilder();
                        sb1.append(tileName);
                        sb1.append(": ");
                        sb1.append(c);
                        sb1.append(" of ");
                        sb1.append(newCols);
                        this.pm.message(sb1.toString());
                    }
                    for (int r = this.pBuffer; r < newRows - this.pBuffer; ++r) {
                        Coordinate coordinate = CoverageUtilities.coordinateFromColRow((int)c, (int)r, (GridGeometry2D)bufferedGridGeometry);
                        ArrayList<LasRecord> currentPoints = new ArrayList<LasRecord>();
                        for (int tmpC = c - this.pBuffer; tmpC <= c + this.pBuffer; ++tmpC) {
                            for (int tmpR = r - this.pBuffer; tmpR <= r + this.pBuffer; ++tmpR) {
                                currentPoints.addAll(lasMatrix[tmpC][tmpR]);
                            }
                        }
                        int size = currentPoints.size();
                        if (size < this.pMinpoints) continue;
                        try {
                            double[] parameters = this.calculateParameters(currentPoints);
                            double interpolatedValue = this.getInterpolatedValue(parameters, coordinate.x, coordinate.y);
                            if (interpolatedValue < this.minValue) {
                                interpolatedValue = this.minValue;
                            }
                            if (interpolatedValue > this.maxValue) {
                                interpolatedValue = this.maxValue;
                            }
                            CoverageUtilities.colRowFromCoordinate((Coordinate)coordinate, (GridGeometry2D)gridGeometry, (Point)point);
                            outWIter.setSample(point.x, point.y, 0, interpolatedValue);
                            continue;
                        }
                        catch (SingularMatrixException singularMatrixException) {
                            // empty catch block
                        }
                    }
                }
            }
            finally {
                if (outWIter != null) {
                    outWIter.done();
                }
            }
            this.dumpRaster(outputCoverage, outTileFile.getAbsolutePath());
        } else {
            this.pm.message(tileName + " ignored because of no points there.");
        }
    }

    private double[] calculateParameters(List<LasRecord> pointsInGeometry) {
        int pointsNum = pointsInGeometry.size();
        double[][] xyMatrix = new double[pointsNum][6];
        double[] valueArray = new double[pointsNum];
        for (int i = 0; i < pointsNum; ++i) {
            LasRecord dot = pointsInGeometry.get(i);
            xyMatrix[i][0] = dot.x * dot.x;
            xyMatrix[i][1] = dot.y * dot.y;
            xyMatrix[i][2] = dot.x * dot.y;
            xyMatrix[i][3] = dot.x;
            xyMatrix[i][4] = dot.y;
            xyMatrix[i][5] = 1.0;
            valueArray[i] = this.doIntensity ? (double)dot.intensity : dot.z;
        }
        RealMatrix A = MatrixUtils.createRealMatrix((double[][])xyMatrix);
        RealVector z = MatrixUtils.createRealVector((double[])valueArray);
        DecompositionSolver solver = new RRQRDecomposition(A).getSolver();
        RealVector solution = solver.solve(z);
        double[] parameters = solution.toArray();
        return parameters;
    }

    private double getInterpolatedValue(double[] parameters, double x, double y) {
        double z = parameters[0] * x * x + parameters[1] * y * y + parameters[2] * x * y + parameters[3] * x + parameters[4] * y + parameters[5];
        return z;
    }
}

