/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.modules.r.bobthebuilder.OmsBobTheBuilder;

@Description(value="Builds rasterized artifacts on a raster.")
@Author(name="Andrea Antonello", contact="www.hydrologis.com")
@Keywords(value="Build, Raster")
@Label(value="Raster Processing")
@Name(value="_bobbuilder")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class BobTheBuilder
extends HMModel {
    @Description(value="The input raster.")
    @UI(value="infile_raster")
    @In
    public String inRaster = null;
    @Description(value="The vector map containing the polygonal area to modify.")
    @UI(value="infile_vector")
    @In
    public String inArea = null;
    @Description(value="The vector map containing the points that provide the new elevations.")
    @UI(value="infile_vector")
    @In
    public String inElevations = null;
    @Description(value="The maximum radius to use for interpolation.")
    @In
    public double pMaxbuffer = -1.0;
    @Description(value="The field of the elevations map that contain the elevation of the point.")
    @In
    public String fElevation = null;
    @Description(value="Switch that defines if the module should erode in places the actual raster is higher (default is false).")
    @In
    public boolean doErode = false;
    @Description(value="Switch that defines if the module should use only points contained in the polygon for the interpolation (default is false. i.e. use all).")
    @In
    public boolean doUseOnlyInternal = false;
    @Description(value="Switch that defines if the module should add the border of the polygon as elevation point to aid connection between new and old (default is false).")
    @In
    public boolean doPolygonborder = false;
    @Description(value="The modified raster map.")
    @UI(value="outfile")
    @In
    public String outRaster = null;

    @Execute
    public void process() throws Exception {
        this.checkNull(new Object[]{this.inRaster, this.inArea, this.inElevations, this.fElevation});
        OmsBobTheBuilder bob = new OmsBobTheBuilder();
        bob.pm = this.pm;
        bob.inRaster = this.getRaster(this.inRaster);
        bob.inArea = this.getVector(this.inArea);
        bob.inElevations = this.getVector(this.inElevations);
        bob.pMaxbuffer = this.pMaxbuffer;
        bob.fElevation = this.fElevation;
        bob.doErode = this.doErode;
        bob.doUseOnlyInternal = this.doUseOnlyInternal;
        bob.doPolygonborder = this.doPolygonborder;
        bob.process();
        this.dumpRaster(bob.outRaster, this.outRaster);
    }
}

