/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.hmachine.modules.statistics.cb.OmsCb;

@Description(value="Calculates the histogram of a set of data contained in a matrix with respect to the set of data contained in another matrix.")
@Author(name="Andrea Antonello, Silvia Franceschi, Rigon Riccardo", contact="http://www.hydrologis.com, http://www.ing.unitn.it/dica/hp/?user=rigon")
@Keywords(value="Histogram, Geomorphology, Statistic")
@Label(value="HortonMachine/Statistics")
@Name(value="_cb")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class Cb
extends HMModel {
    @Description(value="The first raster to analyse.")
    @UI(value="infile_raster")
    @In
    public String inRaster1 = null;
    @Description(value="The second raster to analyse.")
    @UI(value="infile_raster")
    @In
    public String inRaster2 = null;
    @Description(value="The number of bins into which divide the data range.")
    @In
    public int pBins = 100;
    @Description(value="The first moment to calculate.")
    @In
    public int pFirst = 1;
    @Description(value="The last moment to calculate.")
    @In
    public int pLast = 2;
    @Description(value="A matrix containing 1) the mean value of the data in abscissa; 2) the number of elements in each interval; 3) the mean value of the data in ordinate; n+2) the n-esimal moment of the data in ordinate.")
    @Out
    public double[][] outCb;

    @Execute
    public void process() throws Exception {
        OmsCb cb = new OmsCb();
        cb.inRaster1 = this.getRaster(this.inRaster1);
        cb.inRaster2 = this.getRaster(this.inRaster2);
        cb.pBins = this.pBins;
        cb.pFirst = this.pFirst;
        cb.pLast = this.pLast;
        cb.pm = this.pm;
        cb.process();
        this.outCb = cb.outCb;
    }
}

