/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.hmachine.modules.network.distancetooutlet.OmsDistanceToOutlet;

@Description(value="Calculates the projection on the plane of the distance of each pixel from the outlet.")
@Author(name="Andreis Daniele, Erica Ghesla, Antonello Andrea, Cozzini Andrea, PisoniSilvano, Rigon Riccardo", contact="")
@Keywords(value="Geomorphology, OmsDrainDir")
@Label(value="HortonMachine/Network")
@Name(value="_d2o")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class DistanceToOutlet
extends HMModel {
    @Description(value="The map of depitted elevation, if it's null the models work in 2d mode.")
    @UI(value="infile_raster")
    @In
    public String inPit = null;
    @Description(value="The map of flowdirections.")
    @UI(value="infile_raster")
    @In
    public String inFlow = null;
    @Description(value="Processing mode, 0= simple mode in meter, 1 = topological distance.")
    @In
    public int pMode;
    @Description(value="The map of the distance to the outlet.")
    @UI(value="outfile")
    @In
    public String outDistance = null;

    @Execute
    public void process() throws Exception {
        OmsDistanceToOutlet distancetooutlet = new OmsDistanceToOutlet();
        distancetooutlet.inPit = this.getRaster(this.inPit);
        distancetooutlet.inFlow = this.getRaster(this.inFlow);
        distancetooutlet.pMode = this.pMode;
        distancetooutlet.pm = this.pm;
        distancetooutlet.doProcess = this.doProcess;
        distancetooutlet.doReset = this.doReset;
        distancetooutlet.process();
        this.dumpRaster(distancetooutlet.outDistance, this.outDistance);
    }
}

