/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import java.util.ArrayList;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.hortonmachine.gears.io.vectorreader.OmsVectorReader;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.modules.r.tmsgenerator.OmsTmsGenerator;
import org.hortonmachine.gears.utils.files.FileUtilities;

@Description(value="A map creator for geopaparazzi.")
@Author(name="Andrea Antonello, Silvia Franceschi", contact="www.hydrologis.com")
@Keywords(value="geopaparazzi, maps")
@Label(value="Mobile")
@Name(value="geopaparazzimapscreator")
@Status(value=10)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class GeopaparazziMapsCreator
extends HMModel {
    @Description(value="Area of interest shapefile.")
    @UI(value="infile_vector")
    @In
    public String inROI = null;
    @Description(value="Zoom limit area shapefile.")
    @UI(value="infile_vector")
    @In
    public String inZoomLimitROI = null;
    @Description(value="Optional input raster map 1.")
    @UI(value="infile_raster")
    @In
    public String inRaster1 = null;
    @Description(value="Optional input raster map 2.")
    @UI(value="infile_raster")
    @In
    public String inRaster2 = null;
    @Description(value="Optional input vector map 1.")
    @UI(value="infile_vector")
    @In
    public String inVector1 = null;
    @Description(value="Optional input vector map 2.")
    @UI(value="infile_vector")
    @In
    public String inVector2 = null;
    @Description(value="Optional input vector map 3.")
    @UI(value="infile_vector")
    @In
    public String inVector3 = null;
    @Description(value="Optional input vector map 4.")
    @UI(value="infile_vector")
    @In
    public String inVector4 = null;
    @Description(value="Optional input vector map 5.")
    @UI(value="infile_vector")
    @In
    public String inVector5 = null;
    @Description(value="Dataset name")
    @In
    public String pName = "newdataset";
    @Description(value="Min zoom level.")
    @In
    public int pMinZoom = 13;
    @Description(value="Max zoom level.")
    @In
    public int pMaxZoom = 19;
    @Description(value="Zoom limit.")
    @In
    public int pZoomLimit = 19;
    @Description(value="Image type.")
    @In
    @UI(value="combo: png,jpg")
    public String pImageType = "png";
    @Description(value="The output folder.")
    @UI(value="outfolder")
    @In
    public String outFolder = null;

    @Execute
    public void process() throws Exception {
        this.checkNull(new Object[]{this.inROI, this.outFolder});
        SimpleFeatureCollection boundsVector = OmsVectorReader.readVector((String)this.inROI);
        ReferencedEnvelope bounds = boundsVector.getBounds();
        OmsTmsGenerator gen = new OmsTmsGenerator();
        if (this.inRaster1 != null || this.inRaster2 != null) {
            ArrayList<String> inRasters = new ArrayList<String>();
            if (this.inRaster1 != null) {
                inRasters.add(this.inRaster1);
            }
            if (this.inRaster2 != null) {
                inRasters.add(this.inRaster2);
            }
            gen.inRasterFile = FileUtilities.stringListAsTmpFile(inRasters).getAbsolutePath();
        }
        if (this.inVector1 != null || this.inVector2 != null || this.inVector3 != null || this.inVector4 != null || this.inVector5 != null) {
            ArrayList<String> inVectors = new ArrayList<String>();
            if (this.inVector1 != null) {
                inVectors.add(this.inVector1);
            }
            if (this.inVector2 != null) {
                inVectors.add(this.inVector2);
            }
            if (this.inVector3 != null) {
                inVectors.add(this.inVector3);
            }
            if (this.inVector4 != null) {
                inVectors.add(this.inVector4);
            }
            if (this.inVector5 != null) {
                inVectors.add(this.inVector5);
            }
            gen.inVectorFile = FileUtilities.stringListAsTmpFile(inVectors).getAbsolutePath();
        }
        gen.pMinzoom = this.pMinZoom;
        gen.pMaxzoom = this.pMaxZoom;
        gen.pName = this.pName;
        gen.inPath = this.outFolder;
        gen.pWest = bounds.getMinX();
        gen.pEast = bounds.getMaxX();
        gen.pNorth = bounds.getMaxY();
        gen.pSouth = bounds.getMinY();
        gen.dataCrs = bounds.getCoordinateReferenceSystem();
        gen.doMbtiles = true;
        gen.inZoomLimitVector = this.inZoomLimitROI;
        gen.pZoomLimit = this.pZoomLimit;
        switch (this.pImageType) {
            case "jpg": {
                gen.pImagetype = 1;
                break;
            }
            default: {
                gen.pImagetype = 0;
            }
        }
        gen.pm = this.pm;
        gen.process();
    }
}

