/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.hmachine.modules.hillslopeanalyses.h2ca.OmsH2cA;

@Description(value="Select a hillslope or some of its property from the DEM")
@Author(name="Antonello Andrea, Franceschi Silvia, Andreis Daniele,  Erica Ghesla, Cozzini Andrea, Pisoni Silvano, Rigon Riccardo", contact="http://www.hydrologis.com")
@Keywords(value="Geomorphology, OmsDrainDir")
@Label(value="HortonMachine/Hillslope")
@Name(value="_OmsH2cA")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class H2cA
extends HMModel {
    @Description(value="The map of flowdirections.")
    @UI(value="infile_raster")
    @In
    public String inFlow = null;
    @Description(value="The map with the net.")
    @UI(value="infile_raster")
    @In
    public String inNet = null;
    @Description(value="The map of the attribute to estimate.")
    @UI(value="infile_raster")
    @In
    public String inAttribute = null;
    @Description(value="The output map of the attribute.")
    @UI(value="outfile")
    @In
    public String outAttribute = null;

    @Execute
    public void process() throws Exception {
        OmsH2cA h2ca = new OmsH2cA();
        h2ca.inFlow = this.getRaster(this.inFlow);
        h2ca.inNet = this.getRaster(this.inNet);
        h2ca.inAttribute = this.getRaster(this.inAttribute);
        h2ca.pm = this.pm;
        h2ca.doProcess = this.doProcess;
        h2ca.doReset = this.doReset;
        h2ca.process();
        this.dumpRaster(h2ca.outAttribute, this.outAttribute);
    }
}

