/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.hmachine.modules.hydrogeomorphology.infiltration.OmsInfiltratedWaterVolume;

@Description(value="The Infiltrated Watervolume model (from INVEST).")
@Author(name="The klab team.", contact="www.integratedmodelling.org")
@Keywords(value="infiltration")
@Label(value="HortonMachine/Hydro-Geomorphology")
@Name(value="InfiltratedWaterVolume")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class InfiltratedWaterVolume
extends HMModel {
    @Description(value="The potential evapotranspired watervolume.")
    @UI(value="infile_raster")
    @In
    public String inPet = null;
    @Description(value="The rainfall volume.")
    @UI(value="infile_raster")
    @In
    public String inRainfall;
    @Description(value="The map of flowdirections (D8).")
    @UI(value="infile_raster")
    @In
    public String inFlowdirections = null;
    @Description(value="The map of net.")
    @UI(value="infile_raster")
    @In
    public String inNet = null;
    @Description(value="The map of atmospheric temperature.")
    @UI(value="infile_raster")
    @In
    public String inRunoff = null;
    @Description(value="Fraction of upslope available recharge (upgradient subsidy) that is available for month m or for the selected reference interval.")
    @In
    public double pAlpha = 1.0;
    @Description(value="Spatial availability parameter: the fraction of the upgradient subsidy that is available for downgradient evapotranspiration, it is based on local topography and geology")
    @In
    public double pBeta = 1.0;
    @Description(value="Fraction of pixel recharge that is available to downgradient pixels, represents what extent local recharge enters a local groundwater system and might be used again as oppose to entering a deeper groundwater system")
    @In
    public double pGamma = 1.0;
    @Description(value="The map of actual evapotranspiration.")
    @UI(value="outfile")
    @In
    public String outAet = null;
    @Description(value="The map of Lsum Available.")
    @UI(value="outfile")
    @In
    public String outLsumAvailable = null;
    @Description(value="The map of net infiltration.")
    @UI(value="outfile")
    @In
    public String outNetInfiltration = null;
    @Description(value="The map of infiltration.")
    @UI(value="outfile")
    @In
    public String outInfiltration = null;

    @Execute
    public void process() throws Exception {
        OmsInfiltratedWaterVolume inf = new OmsInfiltratedWaterVolume();
        inf.inPet = this.getRaster(this.inPet);
        inf.inRainfall = this.getRaster(this.inRainfall);
        inf.inFlowdirections = this.getRaster(this.inFlowdirections);
        inf.inNet = this.getRaster(this.inNet);
        inf.inRunoff = this.getRaster(this.inRunoff);
        inf.pAlpha = this.pAlpha;
        inf.pBeta = this.pBeta;
        inf.pGamma = this.pGamma;
        inf.pm = this.pm;
        inf.process();
        this.dumpRaster(inf.outInfiltration, this.outInfiltration);
        this.dumpRaster(inf.outNetInfiltration, this.outNetInfiltration);
        this.dumpRaster(inf.outAet, this.outAet);
        this.dumpRaster(inf.outLsumAvailable, this.outLsumAvailable);
    }
}

