/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.hmachine.modules.hydrogeomorphology.insolation.OmsInsolation;

@Description(value="Calculate the amount of power incident on a surface in a period of time.")
@Author(name="Daniele Andreis and Riccardo Rigon", contact="http://www.ing.unitn.it/dica/hp/?user=rigon")
@Keywords(value="Hydrology, Radiation, SkyviewFactor, OmsHillshade")
@Label(value="HortonMachine/Hydro-Geomorphology")
@Name(value="_insolation")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class Insolation
extends HMModel {
    @Description(value="The map of the elevation.")
    @UI(value="infile_raster")
    @In
    public String inElev = null;
    @Description(value="The first day of the simulation.")
    @In
    public String tStartDate = null;
    @Description(value="The last day of the simulation.")
    @In
    public String tEndDate = null;
    @Description(value="The map of total insolation.")
    @UI(value="outfile")
    @In
    public String outIns;

    @Execute
    public void process() throws Exception {
        OmsInsolation insolation = new OmsInsolation();
        insolation.inElev = this.getRaster(this.inElev);
        insolation.tStartDate = this.tStartDate;
        insolation.tEndDate = this.tEndDate;
        insolation.pm = this.pm;
        insolation.doProcess = this.doProcess;
        insolation.doReset = this.doReset;
        insolation.process();
        this.dumpRaster(insolation.outIns, this.outIns);
    }
}

