/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.modules.v.intersections.OmsIntersectionFinder;

@Description(value="Finds intersection geometries in feature collections")
@Author(name="Andrea Antonello", contact="www.hydrologis.com")
@Keywords(value="Vector")
@Label(value="Vector Processing")
@Name(value="_intersectionfinder")
@Status(value=10)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class IntersectionFinder
extends HMModel {
    @Description(value="The map to test for intersections.")
    @UI(value="infile_vector")
    @In
    public String inMap = null;
    @Description(value="The intersections points map.")
    @UI(value="outfile")
    @In
    public String outPointsMap = null;
    @Description(value="The intersections lines map.")
    @UI(value="outfile")
    @In
    public String outLinesMap = null;

    @Execute
    public void process() throws Exception {
        OmsIntersectionFinder intersectionfinder = new OmsIntersectionFinder();
        intersectionfinder.inMap = this.getVector(this.inMap);
        intersectionfinder.pm = this.pm;
        intersectionfinder.doProcess = this.doProcess;
        intersectionfinder.doReset = this.doReset;
        intersectionfinder.process();
        this.dumpVector(intersectionfinder.outPointsMap, this.outPointsMap);
        this.dumpVector(intersectionfinder.outLinesMap, this.outLinesMap);
    }
}

