/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import oms3.annotations.Unit;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.hmachine.modules.hydrogeomorphology.lwrecruitment.OmsLW04_BankfullWidthAnalyzer;

@Description(value="Extracts the bankfull width for each section of the channels and adds it as an attribute to the input layer.")
@Author(name="Silvia Franceschi, Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="network, vector, point, bankflull, width")
@Label(value="HortonMachine/Hydro-Geomorphology/LWRecruitment")
@Name(value="lw04_bankfullwidthanalyzer")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class LW04_BankfullWidthAnalyzer
extends HMModel {
    @Description(value="The input polygon layer of the bankfull area.")
    @UI(value="infile_vector")
    @In
    public String inBankfull = null;
    @Description(value="The input hierarchy point network layer.")
    @UI(value="infile_vector")
    @In
    public String inNetPoints = null;
    @Description(value="The maximum distance that a point can have from the nearest polygon. If distance is major, then the netpoint is ignored and identified as outside the region of interest.")
    @Unit(value="m")
    @In
    public double pMaxDistanceFromNetpoint = 100.0;
    @Description(value="The maximum width for the channel network")
    @Unit(value="m")
    @In
    public double pMaxNetworkWidth = 100.0;
    @Description(value="The minimum width for the channel network")
    @Unit(value="m")
    @In
    public double pMinNetworkWidth = 0.5;
    @Description(value="The output points network layer with the additional attribute of bankfull width.")
    @UI(value="outfile")
    @In
    public String outNetPoints = null;
    @Description(value="The output points layer highlighting the position of the problematic sections.")
    @UI(value="outfile")
    @In
    public String outProblemPoints = null;
    @Description(value="The output layer with the sections lines where the bankfull width has been calculated.")
    @UI(value="outfile")
    @In
    public String outBankfullSections = null;

    @Execute
    public void process() throws Exception {
        OmsLW04_BankfullWidthAnalyzer m = new OmsLW04_BankfullWidthAnalyzer();
        m.inBankfull = this.getVector(this.inBankfull);
        m.inNetPoints = this.getVector(this.inNetPoints);
        m.pMaxDistanceFromNetpoint = this.pMaxDistanceFromNetpoint;
        m.pMaxNetworkWidth = this.pMaxNetworkWidth;
        m.pMinNetworkWidth = this.pMinNetworkWidth;
        m.pm = this.pm;
        m.process();
        this.dumpVector(m.outNetPoints, this.outNetPoints);
        this.dumpVector(m.outProblemPoints, this.outProblemPoints);
        this.dumpVector(m.outBankfullSections, this.outBankfullSections);
    }
}

