/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.hmachine.modules.hydrogeomorphology.lwrecruitment.LWFields;
import org.hortonmachine.hmachine.modules.hydrogeomorphology.lwrecruitment.OmsLW08_NetworkBufferWidthCalculator;

@Description(value="Calculate the inundation zones along the channel network following a power law for the new width based on the original widht and the channel slope.")
@Author(name="Silvia Franceschi, Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="network, vector, bankflull, width, inundation, power law")
@Label(value="HortonMachine/Hydro-Geomorphology/LWRecruitment")
@Name(value="_lw08_networkbufferwidthcalculator")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class LW08_NetworkBufferWidthCalculator
extends HMModel
implements LWFields {
    @Description(value="The input hierarchy point network layer with the information of local slope.")
    @UI(value="infile_vector")
    @In
    public String inNetPoints = null;
    @Description(value="The input polygon layer with the geological superficial geological formations.")
    @UI(value="infile_vector")
    @In
    public String inGeo = null;
    @Description(value="The input line shapefile with the extracted transversal sections.")
    @UI(value="infile_vector")
    @In
    public String inTransSect = null;
    @Description(value="The number of cells upstream and downstream to consider to evaluate the average slope in each section.")
    @In
    public int pPrePostCount4Slope = 10;
    @Description(value="Formula constant of the power law for the evaluation of the new width: newWidth = width + k * slope^n or Wr = k * omega^n")
    @In
    public double pK = 20.0;
    @Description(value="Formula exponent of the power law for the evaluation of the new width: newWidth = width + k * slope^n or Wr = k * omega^n")
    @In
    public double pN = -0.2;
    @Description(value="The boolean to select if considering the width of dams and bridges or not.")
    @In
    public boolean doKeepBridgeDamWidth = true;
    @Description(value="The value to use for the places where the slope is zero in the input raster map.")
    @In
    public double pMinSlope = 0.001;
    @Description(value="The output points network layer with the additional attribute of inundated width and average slope.")
    @UI(value="outfile")
    @In
    public String outNetPoints = null;
    @Description(value="The output polygon layer with the inundation areas.")
    @UI(value="outfile")
    @In
    public String outInundationArea = null;
    @Description(value="The output layer with the sections lines where the inundation width has been calculated.")
    @UI(value="outfile")
    @In
    public String outInundationSections = null;

    @Execute
    public void process() throws Exception {
        OmsLW08_NetworkBufferWidthCalculator ex = new OmsLW08_NetworkBufferWidthCalculator();
        ex.inNetPoints = this.getVector(this.inNetPoints);
        ex.inGeo = this.getVector(this.inGeo);
        ex.inTransSect = this.getVector(this.inTransSect);
        ex.pPrePostCount4Slope = this.pPrePostCount4Slope;
        ex.pK = this.pK;
        ex.pN = this.pN;
        ex.doKeepBridgeDamWidth = this.doKeepBridgeDamWidth;
        ex.pMinSlope = this.pMinSlope;
        ex.pm = this.pm;
        ex.process();
        this.dumpVector(ex.outNetPoints, this.outNetPoints);
        this.dumpVector(ex.outInundationArea, this.outInundationArea);
        this.dumpVector(ex.outInundationSections, this.outInundationSections);
    }
}

