/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.modules.v.smoothing.OmsLineSmootherJaitools;

@Description(value="The line smoother from the jaitools project.")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Smoothing, Vector")
@Label(value="Vector Processing")
@Name(value="_linesmootherjai")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class LineSmootherJaitools
extends HMModel {
    @Description(value="The vector containing the lines to be smoothed.")
    @UI(value="infile_vector")
    @In
    public String inVector;
    @Description(value="A value between 0 and 1 (inclusive) specifying the tightness of fit of the smoothed boundary (0 is loose).")
    @In
    public double pAlpha = 0.0;
    @Description(value="The smoothed features.")
    @UI(value="outfile")
    @In
    public String outVector;

    @Execute
    public void process() throws Exception {
        OmsLineSmootherJaitools linesmootherjaitools = new OmsLineSmootherJaitools();
        linesmootherjaitools.inVector = this.getVector(this.inVector);
        linesmootherjaitools.pAlpha = this.pAlpha;
        linesmootherjaitools.pm = this.pm;
        linesmootherjaitools.doProcess = this.doProcess;
        linesmootherjaitools.doReset = this.doReset;
        linesmootherjaitools.process();
        this.dumpVector(linesmootherjaitools.outVector, this.outVector);
    }
}

