/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.hmachine.modules.geomorphology.nabla.OmsNabla;

@Description(value="Calculates the nabla in each point of the map.")
@Documentation(value="")
@Author(name="Antonello Andrea, Daniele Andreis, Erica Ghesla, Cozzini Andrea, Franceschi Silvia, Pisoni Silvano, Rigon Riccardo", contact="http://www.hydrologis.com, http://www.ing.unitn.it/dica/hp/?user=rigon")
@Keywords(value="Geomorphology, Nabla, Gradient")
@Label(value="HortonMachine/Geomorphology")
@Name(value="nabla")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class Nabla
extends HMModel {
    @Description(value="The map of the digital elevation model (DEM or pit).")
    @UI(value="infile_raster")
    @In
    public String inElev = null;
    @Description(value="An optional threshold on the nabla value.")
    @In
    public Double pThreshold = null;
    @Description(value="The map of nabla.")
    @UI(value="outfile")
    @In
    public String outNabla = null;

    @Execute
    public void process() throws Exception {
        OmsNabla omsnabla = new OmsNabla();
        omsnabla.inElev = this.getRaster(this.inElev);
        omsnabla.pThreshold = this.pThreshold;
        omsnabla.pm = this.pm;
        omsnabla.doProcess = this.doProcess;
        omsnabla.doReset = this.doReset;
        omsnabla.process();
        this.dumpRaster(omsnabla.outNabla, this.outNabla);
    }
}

