/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import java.io.File;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.modules.docker.PdalDockerModel;
import org.json.JSONArray;
import org.json.JSONObject;

@Description(value="Pdal converter LAS->glTF command.")
@Author(name="Antonello Andrea", contact="http://www.hydrologis.com")
@Keywords(value="pdal, docker")
@Label(value="Pdal")
@Name(value="_pdalconverterlas2gltf")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class PdalConverterLas2Gltf
extends PdalDockerModel {
    @Description(value="The las file to convert.")
    @UI(value="infile")
    @In
    public String inPath = null;
    @Description(value="The output file name.")
    @In
    public String outName = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Execute
    public void process() throws Exception {
        this.checkFileExists(new String[]{this.inPath});
        String error = this.checkDockerInstall();
        if (error == null) {
            try {
                File file = new File(this.inPath);
                String inName = file.getName();
                File workspaceFile = file.getParentFile();
                String workspace = workspaceFile.getAbsolutePath();
                JSONArray pipelineArray = new JSONArray();
                JSONObject filter = new JSONObject();
                filter.put("type", (Object)"filters.poisson");
                pipelineArray.put((Object)filter);
                JSONObject writer = new JSONObject();
                writer.put("type", (Object)"writers.gltf");
                writer.put("filename", (Object)this.outName);
                writer.put("red", 0.8);
                writer.put("metallic", 0.5);
                pipelineArray.put((Object)writer);
                String pipelineJson = pipelineArray.toString(2);
                pipelineJson = pipelineJson.replaceFirst("\\[", "[\n\"" + inName + "\",");
                this.pm.message("Running pipeline with filter:");
                this.pm.message(pipelineJson);
                File pipelineFile = this.getPipelineFile(workspaceFile, pipelineJson);
                String cmd = "pdal pipeline " + pipelineFile.getName();
                this.startContainer(workspace);
                this.pm.beginTask("Running command...", -1);
                this.execCommand(cmd);
                this.pm.done();
                pipelineFile.delete();
            }
            finally {
                this.closeClient();
            }
        } else {
            this.pm.errorMessage(error);
        }
    }

    public static void main(String[] args) throws Exception {
        PdalConverterLas2Gltf i = new PdalConverterLas2Gltf();
        i.inPath = "/Users/hydrologis/lavori_tmp/R3GIS_TESTS/LAS/erdbau_las.laz";
        i.outName = "erdbau.glb";
        i.process();
    }
}

