/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import java.io.File;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.modules.docker.PdalDockerModel;

@Description(value="PdalInfo command.")
@Author(name="Antonello Andrea", contact="http://www.hydrologis.com")
@Keywords(value="pdal, docker")
@Label(value="Pdal")
@Name(value="_pdalinfo")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class PdalInfo
extends PdalDockerModel {
    @Description(value="The pdal file to check.")
    @UI(value="infile")
    @In
    public String inPath = null;
    @Description(value="Print metadata.")
    @In
    public boolean doMetadata = true;
    @Description(value="Print schema.")
    @In
    public boolean doSchema = false;
    @Description(value="Print statistics on all points (reads the dataset).")
    @In
    public boolean doStats = false;
    @Description(value="A range of points information to print out.")
    @In
    public String pPointsRange = "1-3";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Execute
    public void process() throws Exception {
        this.checkFileExists(new String[]{this.inPath});
        String error = this.checkDockerInstall();
        if (error == null) {
            try {
                File file = new File(this.inPath);
                String workspace = file.getParentFile().getAbsolutePath();
                String cmd = "pdal info " + file.getName();
                if (this.doMetadata) {
                    cmd = cmd + " --metadata";
                }
                if (this.doSchema) {
                    cmd = cmd + " --schema";
                }
                if (this.doStats) {
                    cmd = cmd + " --stats";
                }
                if (this.pPointsRange.trim().length() > 0) {
                    cmd = cmd + " -p " + this.pPointsRange;
                }
                this.pm.message(cmd);
                this.startContainer(workspace);
                this.execCommand(cmd);
            }
            finally {
                this.closeClient();
            }
        } else {
            this.pm.errorMessage(error);
        }
    }

    public static void main(String[] args) throws Exception {
        PdalInfo i = new PdalInfo();
        i.inPath = "/Users/hydrologis/data/las/EXAMPLE_river.las";
        i.doMetadata = true;
        i.doSchema = true;
        i.pPointsRange = "1-2";
        i.process();
    }
}

