/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.coverage.grid.GridGeometry2D;
import org.hortonmachine.gears.io.gridgeometryreader.OmsGridGeometryReader;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.modules.r.pointsrasterizer.OmsPointsRasterizer;

@Description(value="Module to convert vector points to raster. Currently this does simply put the point in the nearest cell, without check.")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Raster, Vector, Points")
@Label(value="Raster Processing")
@Name(value="_rasterizepoints")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class PointsRasterizer
extends HMModel {
    @Description(value="The points vector.")
    @UI(value="infile_vector")
    @In
    public String inVector = null;
    @Description(value="The boundary north coordinate.")
    @UI(value="process_north")
    @In
    public Double pNorth = null;
    @Description(value="The boundary south coordinate.")
    @UI(value="process_south")
    @In
    public Double pSouth = null;
    @Description(value="The boundary west coordinate.")
    @UI(value="process_west")
    @In
    public Double pWest = null;
    @Description(value="The boundary east coordinate.")
    @UI(value="process_east")
    @In
    public Double pEast = null;
    @Description(value="The resolution in x.")
    @UI(value="process_xres")
    @In
    public Double pXres = null;
    @Description(value="The resolution in y.")
    @UI(value="process_yres")
    @In
    public Double pYres = null;
    @Description(value="The code defining the coordinate reference system, composed by authority and code number (ex. EPSG:4328).")
    @UI(value="crs")
    @In
    public String pCode;
    @Description(value="The field of the vector to take the category from.")
    @In
    public String fCat;
    @Description(value="The output raster.")
    @UI(value="outfile")
    @In
    public String outRaster;

    @Execute
    public void process() throws Exception {
        OmsGridGeometryReader gridgeometryreader = new OmsGridGeometryReader();
        gridgeometryreader.pNorth = this.pNorth;
        gridgeometryreader.pSouth = this.pSouth;
        gridgeometryreader.pWest = this.pWest;
        gridgeometryreader.pEast = this.pEast;
        gridgeometryreader.pXres = this.pXres;
        gridgeometryreader.pYres = this.pYres;
        gridgeometryreader.pCode = this.pCode;
        gridgeometryreader.pm = this.pm;
        gridgeometryreader.doProcess = this.doProcess;
        gridgeometryreader.doReset = this.doReset;
        gridgeometryreader.process();
        GridGeometry2D outGridgeom = gridgeometryreader.outGridgeom;
        OmsPointsRasterizer pointsrasterizer = new OmsPointsRasterizer();
        pointsrasterizer.inVector = this.getVector(this.inVector);
        pointsrasterizer.inGrid = outGridgeom;
        pointsrasterizer.fCat = this.fCat;
        pointsrasterizer.pm = this.pm;
        pointsrasterizer.doProcess = this.doProcess;
        pointsrasterizer.doReset = this.doReset;
        pointsrasterizer.process();
        this.dumpRaster(pointsrasterizer.outRaster, this.outRaster);
    }
}

