/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.hmachine.modules.hydrogeomorphology.etp.OmsPotentialEvapotranspiredWaterVolume;

@Description(value="The Potential Evapotranspired Watervolume model (from INVEST).")
@Author(name="The klab team.", contact="www.integratedmodelling.org")
@Keywords(value="potential, evapotranspiration")
@Label(value="HortonMachine/Hydro-Geomorphology")
@Name(value="PotentialEvapotranspiredWaterVolume")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class PotentialEvapotranspiredWaterVolume
extends HMModel {
    @Description(value="The map of crop coefficient.")
    @UI(value="infile_raster")
    @In
    public String inCropCoefficient = null;
    @Description(value="The map of maximum temperature.")
    @UI(value="infile_raster")
    @In
    public String inMaxTemp = null;
    @Description(value="The map of minimum temperature.")
    @UI(value="infile_raster")
    @In
    public String inMinTemp = null;
    @Description(value="The map of atmospheric temperature.")
    @UI(value="infile_raster")
    @In
    public String inAtmosphericTemp = null;
    @Description(value="The map of solar radiation.")
    @UI(value="infile_raster")
    @In
    public String inSolarRadiation = null;
    @Description(value="The rainfall volume.")
    @UI(value="infile_raster")
    @In
    public String inRainfall;
    @Description(value="The map of reference evapotraspiration (optional, excludes all but the crop coefficient).")
    @UI(value="infile_raster")
    @In
    public String inReferenceEtp = null;
    @Description(value="The output potential evapotranspired watervolume.")
    @UI(value="outfile")
    @In
    public String outputPet;

    @Execute
    public void process() throws Exception {
        OmsPotentialEvapotranspiredWaterVolume pet = new OmsPotentialEvapotranspiredWaterVolume();
        pet.inCropCoefficient = this.getRaster(this.inCropCoefficient);
        pet.inMaxTemp = this.getRaster(this.inMaxTemp);
        pet.inMinTemp = this.getRaster(this.inMinTemp);
        pet.inAtmosphericTemp = this.getRaster(this.inAtmosphericTemp);
        pet.inRainfall = this.getRaster(this.inRainfall);
        pet.inSolarRadiation = this.getRaster(this.inSolarRadiation);
        pet.inReferenceEtp = this.getRaster(this.inReferenceEtp);
        pet.pm = this.pm;
        pet.process();
        this.dumpRaster(pet.outputPet, this.outputPet);
    }
}

