/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.modules.r.rastervectorintersection.OmsRasterVectorIntersector;

@Description(value="Module for raster with polygon vector intersection.")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Raster, Vector, Intersect")
@Label(value="Raster Processing")
@Name(value="_rvintersector")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class RasterVectorIntersector
extends HMModel {
    @Description(value="The polygon vector to use for the intersection.")
    @UI(value="infile_vector")
    @In
    public String inVector = null;
    @Description(value="The raster to use for the intersection.")
    @UI(value="infile_raster")
    @In
    public String inRaster;
    @Description(value="Flag to use to invert the result (default is false = keep data inside vector)")
    @In
    public boolean doInverse = false;
    @Description(value="The output raster.")
    @UI(value="outfile")
    @In
    public String outRaster;

    @Execute
    public void process() throws Exception {
        OmsRasterVectorIntersector rastervectorintersector = new OmsRasterVectorIntersector();
        rastervectorintersector.inVector = this.getVector(this.inVector);
        rastervectorintersector.inRaster = this.getRaster(this.inRaster);
        rastervectorintersector.doInverse = this.doInverse;
        rastervectorintersector.pm = this.pm;
        rastervectorintersector.doProcess = this.doProcess;
        rastervectorintersector.doReset = this.doReset;
        rastervectorintersector.process();
        this.dumpRaster(rastervectorintersector.outRaster, this.outRaster);
    }
}

