/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import oms3.annotations.Unit;
import oms3.io.CSTable;
import oms3.io.DataIO;
import oms3.io.TableIterator;
import org.hortonmachine.gears.io.timeseries.OmsTimeSeriesReader;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.hmachine.modules.hydrogeomorphology.saintgeo.OmsSaintGeo;

@Description(value="A simple 1D hydraulic model based on the equations of Saint Venant.")
@Author(name="Silvia Franceschi, Andrea Antonello, Riccardo Rigon, Angelo Zacchia", contact="www.hydrologis.com")
@Keywords(value="1D, Hydraulic")
@Label(value="HortonMachine/Hydro-Geomorphology")
@Name(value="SaintGeo")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class SaintGeo
extends HMModel {
    @Description(value="The main stream river points (with the elevation in the attribute table).")
    @UI(value="infile_vector")
    @In
    public String inRiverPoints = null;
    @Description(value="The section lines.")
    @UI(value="infile_vector")
    @In
    public String inSections = null;
    @Description(value="The section points (with the elevation in the attribute table).")
    @UI(value="infile_vector")
    @In
    public String inSectionPoints = null;
    @Description(value="Input head discharge.")
    @UI(value="infile_csv")
    @In
    public String inDischarge;
    @Description(value="Input downstream level.")
    @UI(value="infile_csv")
    @In
    public String inDownstreamLevel;
    @Description(value="Lateral discharge tribute or offtake section discharge values for each id.")
    @UI(value="infile_csv")
    @In
    public String inLateralId2Discharge;
    @Description(value="Lateral immission from confluences discharge values for each id.")
    @UI(value="infile_csv")
    @In
    public String inConfluenceId2Discharge;
    @Description(value="Time interval.")
    @Unit(value="millisec")
    @In
    public long pDeltaTMillis = 5000L;
    @Description(value="Output file with levels.")
    @UI(value="outfile")
    @In
    public String outputLevelFile;
    @Description(value="Output file with the quantities related to discharge.")
    @UI(value="outfile")
    @In
    public String outputDischargeFile;

    @Execute
    public void process() throws Exception {
        this.checkNull(new Object[]{this.inRiverPoints, this.inSectionPoints, this.inSections, this.inDischarge});
        OmsSaintGeo saintGeo = new OmsSaintGeo();
        saintGeo.inRiverPoints = this.getVector(this.inRiverPoints);
        saintGeo.inSectionPoints = this.getVector(this.inSectionPoints);
        saintGeo.inSections = this.getVector(this.inSections);
        double[] discharge = this.readToArray(this.inDischarge);
        saintGeo.inDischarge = discharge;
        if (this.inDownstreamLevel != null) {
            double[] level = this.readToArray(this.inDownstreamLevel);
            saintGeo.inDownstreamLevel = level;
        }
        if (this.inLateralId2Discharge != null) {
            HashMap<Integer, double[]> lateralData;
            saintGeo.inLateralId2DischargeMap = lateralData = this.readIdData(this.inLateralId2Discharge);
        }
        if (this.inConfluenceId2Discharge != null) {
            HashMap<Integer, double[]> confluenceData;
            saintGeo.inConfluenceId2DischargeMap = confluenceData = this.readIdData(this.inConfluenceId2Discharge);
        }
        saintGeo.pDeltaTMillis = this.pDeltaTMillis;
        saintGeo.outputLevelFile = this.outputLevelFile;
        saintGeo.outputDischargeFile = this.outputDischargeFile;
        saintGeo.process();
    }

    private HashMap<Integer, double[]> readIdData(String path) throws Exception {
        CSTable table = DataIO.table((File)new File(path), null);
        HashMap dataMap = new HashMap();
        int columnCount = table.getColumnCount();
        int[] ids = new int[columnCount - 1];
        for (int i = 2; i <= columnCount; ++i) {
            int id;
            Map columnInfo = table.getColumnInfo(i);
            String idStr = (String)columnInfo.get("id");
            ids[i - 2] = id = Integer.parseInt(idStr);
        }
        TableIterator rowsIterator = (TableIterator)table.rows().iterator();
        while (rowsIterator.hasNext()) {
            String[] row = (String[])rowsIterator.next();
            for (int i = 2; i < row.length; ++i) {
                ArrayList<Double> dataList = (ArrayList<Double>)dataMap.get(ids[i - 2]);
                if (dataList == null) {
                    dataList = new ArrayList<Double>();
                    dataMap.put(ids[i - 2], dataList);
                }
                double value = -1.0;
                if (row[i] == null || row[i].length() == 0) {
                    value = -9999.0;
                } else {
                    String valueStr = row[i];
                    value = Double.parseDouble(valueStr);
                }
                dataList.add(value);
            }
        }
        HashMap<Integer, double[]> outDataMap = new HashMap<Integer, double[]>();
        for (Map.Entry entry : dataMap.entrySet()) {
            Integer id = (Integer)entry.getKey();
            List valueList = (List)entry.getValue();
            double[] values = new double[valueList.size()];
            for (int i = 0; i < values.length; ++i) {
                values[i] = (Double)valueList.get(i);
            }
            outDataMap.put(id, values);
        }
        return outDataMap;
    }

    private double[] readToArray(String file) throws IOException {
        OmsTimeSeriesReader reader = new OmsTimeSeriesReader();
        reader.file = file;
        reader.fileNovalue = "-9999";
        reader.read();
        HashMap outData = reader.outData;
        double[] data = new double[outData.size()];
        int counter = 0;
        for (double[] values : outData.values()) {
            data[counter++] = values[0];
        }
        return data;
    }

    public static void main(String[] args) throws Exception {
        String base = "D:/Dropbox/hydrologis/lavori/2015_phd_bz/gSoC2015/data/data_adige_test/";
        String inSec = base + "sections_adige_75_rev.shp";
        String inSecP = base + "sectionpoints_adige_75_rev.shp";
        String inRiv = base + "riverpoints_adige_75_rev.shp";
        String inDischarge = base + "head_discharge.csv";
        String inLevel = base + "downstream_waterlevel.csv";
        String inLateral = base + "q_lateral_offtakes.csv";
        String outLevelFile = base + "saintgeo_level_out_offtakes.csv";
        String outDischargeFile = base + "saintgeo_discharge_out_offtakes.csv";
        SaintGeo sg = new SaintGeo();
        sg.inRiverPoints = inRiv;
        sg.inSectionPoints = inSecP;
        sg.inSections = inSec;
        sg.inDischarge = inDischarge;
        sg.inDownstreamLevel = inLevel;
        sg.inLateralId2Discharge = inLateral;
        sg.pDeltaTMillis = 5000L;
        sg.outputLevelFile = outLevelFile;
        sg.outputDischargeFile = outDischargeFile;
        sg.process();
    }
}

