/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.hmachine.modules.hydrogeomorphology.skyview.OmsSkyview;

@Description(value="Calculates the skyview factor.")
@Author(name="Daniele Andreis and Riccardo Rigon", contact="http://www.ing.unitn.it/dica/hp/?user=rigon")
@Keywords(value="Hydrology, Radiation, OmsInsolation, OmsHillshade")
@Label(value="HortonMachine/Hydro-Geomorphology")
@Name(value="_skyview")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class Skyview
extends HMModel {
    @Description(value="The map of the elevation.")
    @UI(value="infile_raster")
    @In
    public String inElev = null;
    @Description(value="The map of skyview factor.")
    @UI(value="outfile")
    @In
    public String outSky;

    @Execute
    public void process() throws Exception {
        OmsSkyview skyview = new OmsSkyview();
        skyview.inElev = this.getRaster(this.inElev);
        skyview.pm = this.pm;
        skyview.doProcess = this.doProcess;
        skyview.doReset = this.doReset;
        skyview.process();
        this.dumpRaster(skyview.outSky, this.outSky);
    }
}

