/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.hmachine.modules.geomorphology.slope.OmsSlope;

@Description(value="Calculates the slope in each point of the map.")
@Author(name="Antonello Andrea, Erica Ghesla, Cozzini Andrea, Franceschi Silvia, Pisoni Silvano, Rigon Riccardo", contact="http://www.hydrologis.com, http://www.ing.unitn.it/dica/hp/?user=rigon")
@Keywords(value="Geomorphology, OmsGradient")
@Label(value="HortonMachine/Geomorphology")
@Name(value="_slope")
@Status(value=20)
@License(value="General Public License Version 3 (GPLv3)")
public class Slope
extends HMModel {
    @Description(value="The depitted elevation map.")
    @UI(value="infile_raster")
    @In
    public String inPit = null;
    @Description(value="The map of flowdirection.")
    @UI(value="infile_raster")
    @In
    public String inFlow = null;
    @Description(value="If true, negative slopes will be set to the minimum positive value.")
    @In
    public boolean doHandleNegativeSlope;
    @Description(value="The map of gradient.")
    @UI(value="outfile")
    @In
    public String outSlope = null;

    @Execute
    public void process() throws Exception {
        OmsSlope slope = new OmsSlope();
        slope.inPit = this.getRaster(this.inPit);
        slope.inFlow = this.getRaster(this.inFlow);
        slope.doHandleNegativeSlope = this.doHandleNegativeSlope;
        slope.pm = this.pm;
        slope.doProcess = this.doProcess;
        slope.doReset = this.doReset;
        slope.process();
        this.dumpRaster(slope.outSlope, this.outSlope);
    }
}

