/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import oms3.annotations.UI;
import oms3.annotations.Unit;
import org.hortonmachine.gears.io.timeseries.OmsTimeSeriesReader;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.utils.files.FileUtilities;
import org.hortonmachine.hmachine.modules.networktools.trento_p.OmsTrentoPCalibration;
import org.joda.time.DateTime;

@Description(value="Module to verify the discharge for each pipe.")
@Author(name="Daniele Andreis, Rigon Riccardo, David tamanini, Andrea Antonello, Silvia Franceschi", contact="")
@Keywords(value="Sewer network")
@Label(value="Others")
@Name(value="")
@Status(value=10)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class TrentoPCalibration
extends HMModel {
    @Description(value="The outlet, the last pipe of the network.")
    @Unit(value="-")
    @In
    public Integer pOutPipe = null;
    @Description(value="Time step used to calculate the discharge. If not set the rain time step is used.")
    @Unit(value="minutes")
    @In
    public Integer dt;
    @Description(value="Max number of time step.")
    @Unit(value="-")
    @In
    public int tMax = 120;
    @Description(value="Maximum Rain Time step to evaluate the Rain.")
    @Unit(value="minutes")
    @In
    public Integer tpMaxCalibration = null;
    @Description(value="rain data.")
    @UI(value="infile_csv")
    @In
    public String inRain = null;
    @Description(value="The TrentoP project data folder.")
    @UI(value="infolder")
    @In
    public String inFolder = null;
    @Description(value="The output feature collection which contains the net with all hydraulics value.")
    @UI(value="outfile")
    @In
    public String outPipes = null;
    @Description(value="The discharge for each pipes at several time.")
    @UI(value="outfile")
    @In
    public String outDischarge;
    @Description(value="The fill degree for each pipes at several time.")
    @UI(value="outfile")
    @In
    public String outFillDegree;
    @Description(value="The time which give the maximum discharge.")
    @Unit(value="minutes")
    @Out
    public Integer outTpMax = null;
    private double[][] results;

    @Execute
    public void process() throws Exception {
        StringBuilder sb;
        this.checkNull(new Object[]{this.inFolder});
        File baseFolderFile = new File(this.inFolder);
        File pipesFile = new File(baseFolderFile, "network_calibration.shp");
        File areasFile = new File(baseFolderFile, "areas.shp");
        File junctionsFile = new File(baseFolderFile, "junctions.shp");
        File parametersFile = new File(baseFolderFile, "parameters.csv");
        this.checkFileExists(new String[]{pipesFile.getAbsolutePath(), areasFile.getAbsolutePath(), junctionsFile.getAbsolutePath(), parametersFile.getAbsolutePath()});
        OmsTrentoPCalibration trento_P = new OmsTrentoPCalibration();
        trento_P.pOutPipe = this.pOutPipe;
        if (this.inRain != null) {
            OmsTimeSeriesReader rainReader = new OmsTimeSeriesReader();
            rainReader.fileNovalue = "-9999";
            rainReader.file = this.inRain;
            rainReader.read();
            rainReader.close();
            trento_P.inRain = rainReader.outData;
        }
        List paramsList = FileUtilities.readFileToLinesList((File)parametersFile);
        paramsList.remove(0);
        HashMap<String, Double> paramsMap = new HashMap<String, Double>();
        for (String paramLine : paramsList) {
            String[] lineSplit = paramLine.split(";");
            paramsMap.put(lineSplit[0], Double.parseDouble(lineSplit[1]));
        }
        trento_P.inParameters = paramsMap;
        trento_P.inPipes = this.getVector(pipesFile.getAbsolutePath());
        trento_P.inAreas = this.getVector(areasFile.getAbsolutePath());
        trento_P.inJunctions = this.getVector(junctionsFile.getAbsolutePath());
        trento_P.dt = this.dt;
        trento_P.tMax = this.tMax;
        trento_P.tpMaxCalibration = this.tpMaxCalibration;
        trento_P.process();
        this.results = trento_P.getResults();
        if (this.outDischarge != null && trento_P.outDischarge != null) {
            double[][] outDisch = this.hashToMatrix(trento_P.outDischarge, this.results.length);
            sb = this.printMatrixData(outDisch);
            FileUtilities.writeFile((String)sb.toString(), (File)new File(this.outDischarge));
        }
        if (this.outFillDegree != null && trento_P.outFillDegree != null) {
            double[][] outFill = this.hashToMatrix(trento_P.outFillDegree, this.results.length);
            sb = this.printMatrixData(outFill);
            FileUtilities.writeFile((String)sb.toString(), (File)new File(this.outFillDegree));
        }
    }

    public double[][] getResults() {
        return this.results;
    }

    private StringBuilder printMatrixData(double[][] matrix) {
        StringBuilder sb = new StringBuilder();
        int cols = matrix[0].length;
        int rows = matrix.length;
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                sb.append(matrix[r][c]);
                sb.append(", ");
            }
            sb.append("\n");
        }
        return sb;
    }

    private double[][] hashToMatrix(HashMap<DateTime, HashMap<Integer, double[]>> outDischarge, int nStation) {
        Set<Map.Entry<DateTime, HashMap<Integer, double[]>>> dischargeSet = outDischarge.entrySet();
        DateTime first = null;
        DateTime second = null;
        int l = outDischarge.size();
        double[][] rainData = new double[l][nStation + 1];
        int index = 0;
        int dt = 0;
        for (Map.Entry<DateTime, HashMap<Integer, double[]>> dischargeRecord : dischargeSet) {
            DateTime dateTime = dischargeRecord.getKey();
            HashMap<Integer, double[]> values = dischargeRecord.getValue();
            if (first == null) {
                first = dateTime;
                rainData[index][0] = 1.0;
                Set<Integer> tmp = values.keySet();
                int i = 0;
                for (Integer f : tmp) {
                    rainData[index][i + 1] = values.get(f)[0];
                    ++i;
                }
            } else if (second == null) {
                second = dateTime;
                dt = Math.abs(second.getMinuteOfDay() - first.getMinuteOfDay());
                rainData[index][0] = rainData[index - 1][0] + (double)dt;
                Set<Integer> tmp = values.keySet();
                int i = 0;
                for (Integer f : tmp) {
                    rainData[index][i + 1] = values.get(f)[0];
                    ++i;
                }
            } else {
                rainData[index][0] = rainData[index - 1][0] + (double)dt;
                int i = 0;
                Set<Integer> tmp = values.keySet();
                for (Integer f : tmp) {
                    rainData[index][i + 1] = values.get(f)[0];
                    ++i;
                }
            }
            ++index;
        }
        return rainData;
    }

    public static void main(String[] args) throws Exception {
        String outFolder = "D:\\Dropbox\\hydrologis\\lavori\\2020_10_trentop\\test_soraga\\new2\\";
        TrentoPCalibration c = new TrentoPCalibration();
        c.pOutPipe = 10;
        c.dt = 5;
        c.tMax = 90;
        c.tpMaxCalibration = 60;
        c.inFolder = outFolder;
        c.outDischarge = outFolder + "outdischarge.csv";
        c.outFillDegree = outFolder + "outfilldegree.csv";
        c.process();
    }
}

