/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.hmachine.modules.demmanipulation.wateroutlet.OmsWateroutlet;

@Description(value="Extract the watershed for a defined outlet (ported from GRASS r.wateroutlet).")
@Author(name="Charles Ehlschlaeger, Andrea Antonello", contact="US Army Construction Engineering Research Laboratory, http://www.hydrologis.com")
@Keywords(value="Dem manipulation, Geomorphology, OmsFlowDirections")
@Label(value="HortonMachine/Dem Manipulation")
@Name(value="_wateroutlet")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class Wateroutlet
extends HMModel {
    @Description(value="The northern coordinate of the watershed outlet.")
    @UI(value="northing")
    @In
    public double pNorth = -1.0;
    @Description(value="The eastern coordinate of the watershed outlet.")
    @UI(value="easting")
    @In
    public double pEast = -1.0;
    @Description(value="The map of flowdirections.")
    @UI(value="infile_raster")
    @In
    public String inFlow;
    @Description(value="The extracted basin mask.")
    @UI(value="outfile")
    @In
    public String outBasin = null;
    @Description(value="The area of the extracted basin.")
    @Out
    public double outArea = 0.0;

    @Execute
    public void process() throws Exception {
        OmsWateroutlet omswateroutlet = new OmsWateroutlet();
        omswateroutlet.pNorth = this.pNorth;
        omswateroutlet.pEast = this.pEast;
        omswateroutlet.inFlow = this.getRaster(this.inFlow);
        omswateroutlet.pm = this.pm;
        omswateroutlet.doProcess = this.doProcess;
        omswateroutlet.doReset = this.doReset;
        omswateroutlet.process();
        this.dumpRaster(omswateroutlet.outBasin, this.outBasin);
    }
}

