/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.modules.r.raster4xyz.OmsXyz2Raster;

@Description(value="Convert evenly spaced XYZ triplets to regular raster grid.")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Raster, Conversion")
@Label(value="Raster Processing")
@Name(value="_xyz2raster")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class Xyz2Raster
extends HMModel {
    @Description(value="The file of regularly distributed xyz triplets.")
    @UI(value="infile")
    @In
    public String inFile;
    @Description(value="The resolution to use.")
    @In
    public Double pRes;
    @Description(value="The code defining the target coordinate reference system, composed by authority and code number (ex. EPSG:4328).")
    @UI(value="crs")
    @In
    public String pCode;
    @Description(value="The value separator (if not set, spaces will be used).")
    @In
    public String pSeparator;
    @Description(value="The generated raster.")
    @UI(value="outfile")
    @In
    public String outRaster;

    @Execute
    public void process() throws Exception {
        OmsXyz2Raster xyz2raster = new OmsXyz2Raster();
        xyz2raster.inFile = this.inFile;
        xyz2raster.pRes = this.pRes;
        xyz2raster.pCode = this.pCode;
        xyz2raster.pSeparator = this.pSeparator;
        xyz2raster.pm = this.pm;
        xyz2raster.doProcess = this.doProcess;
        xyz2raster.doReset = this.doReset;
        xyz2raster.process();
        this.dumpRaster(xyz2raster.outRaster, this.outRaster);
    }
}

