/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import oms3.annotations.Unit;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.hmachine.modules.hydrogeomorphology.debrisvandre.OmsDebrisVandre;

@Description(value="Implementation of the Vandre methodology for Debris handling.")
@Author(name="Andrea Antonello, Silvia Franceschi", contact="www.hydrologis.com")
@Keywords(value="Debris, Raster")
@Label(value="HortonMachine/Hydro-Geomorphology")
@Name(value="_debrisvandre")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class DebrisVandre
extends HMModel {
    @Description(value="The map of elevation.")
    @UI(value="infile_raster")
    @In
    public String inElev = null;
    @Description(value="The map of flow directions.")
    @UI(value="infile_raster")
    @In
    public String inFlow = null;
    @Description(value="The map of slope.")
    @UI(value="infile_raster")
    @Unit(value="degree")
    @In
    public String inSlope = null;
    @Description(value="The map of debris triggering points.")
    @UI(value="infile_raster")
    @In
    public String inTriggers = null;
    @Description(value="The optional map of soil height.")
    @UI(value="infile_raster")
    @In
    public String inSoil = null;
    @Description(value="The optional map of the network (needed if the soil map is supplied).")
    @UI(value="infile_raster")
    @In
    public String inNet = null;
    @Description(value="The flag that defines (in the case of supplied soil map0 if the cumulated should be propagated down the whole network channel.")
    @In
    public boolean doWholenet = false;
    @Description(value="The optional maximum distance (used if the soil map is supplied, defaults to 100 meters).")
    @In
    @Unit(value="m")
    public double pDistance = 100.0;
    @Description(value="An optional point map of obstacles on the network, that can stop the debris path.")
    @UI(value="infile_vector")
    @In
    public String inObstacles = null;
    @Description(value="The criteria mode to use (0 = Burton/Bathurst = default, 1 = Tn modified Barton/Bathurst).")
    @In
    public int pMode = 0;
    @Description(value="The debris paths for every trigger point.")
    @UI(value="outfile")
    @In
    public String outPaths = null;
    @Description(value="The trigger map, linked to the id of its path.")
    @UI(value="outfile")
    @In
    public String outIndexedTriggers = null;
    @Description(value="The optional output map of cumulated soil.")
    @UI(value="outfile")
    @In
    public String outSoil = null;

    @Execute
    public void process() throws Exception {
        OmsDebrisVandre debrisvandre = new OmsDebrisVandre();
        debrisvandre.inElev = this.getRaster(this.inElev);
        debrisvandre.inFlow = this.getRaster(this.inFlow);
        debrisvandre.inSlope = this.getRaster(this.inSlope);
        debrisvandre.inTriggers = this.getRaster(this.inTriggers);
        debrisvandre.inSoil = this.getRaster(this.inSoil);
        debrisvandre.inNet = this.getRaster(this.inNet);
        debrisvandre.doWholenet = this.doWholenet;
        debrisvandre.pDistance = this.pDistance;
        debrisvandre.inObstacles = this.getVector(this.inObstacles);
        debrisvandre.pMode = this.pMode;
        debrisvandre.pm = this.pm;
        debrisvandre.doProcess = this.doProcess;
        debrisvandre.doReset = this.doReset;
        debrisvandre.process();
        this.dumpVector(debrisvandre.outPaths, this.outPaths);
        this.dumpVector(debrisvandre.outIndexedTriggers, this.outIndexedTriggers);
        this.dumpRaster(debrisvandre.outSoil, this.outSoil);
    }
}

