/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.hmachine.modules.geomorphology.gc.OmsGc;

@Description(value="Subdivides the sites of a basin in 11 topographic classes.")
@Author(name="Daniele Andreis,Erica Ghesla, Cozzini Andrea, Rigon Riccardo", contact="")
@Keywords(value="Geomorphology, OmsTc, OmsSlope, OmsExtractNetwork")
@Label(value="HortonMachine/Geomorphology")
@Name(value="_gc")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class Gc
extends HMModel {
    @Description(value="The map of the slope")
    @UI(value="infile_raster")
    @In
    public String inSlope = null;
    @Description(value="The map with the network")
    @UI(value="infile_raster")
    @In
    public String inNetwork = null;
    @Description(value="The map with the Thopological classes cp9")
    @UI(value="infile_raster")
    @In
    public String inCp9 = null;
    @Description(value="The gradient formula mode (0 = finite differences, 1 = horn, 2 = evans).")
    @In
    public int pTh = 0;
    @Description(value="The map with the geomorphological classes")
    @UI(value="outfile")
    @In
    public String outClasses = null;
    @Description(value="The map with the geomorphological classes")
    @UI(value="outfile")
    @In
    public String outAggregateClasses = null;

    @Execute
    public void process() throws Exception {
        OmsGc gc = new OmsGc();
        gc.inSlope = this.getRaster(this.inSlope);
        gc.inNetwork = this.getRaster(this.inNetwork);
        gc.inCp9 = this.getRaster(this.inCp9);
        gc.pTh = this.pTh;
        gc.pm = this.pm;
        gc.doProcess = this.doProcess;
        gc.doReset = this.doReset;
        gc.process();
        this.dumpRaster(gc.outClasses, this.outClasses);
        this.dumpRaster(gc.outAggregateClasses, this.outAggregateClasses);
    }
}

