/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.filter.AttributeExpressionImpl;
import org.geotools.filter.IsEqualsToImpl;
import org.geotools.filter.LiteralExpressionImpl;
import org.geotools.styling.Style;
import org.hortonmachine.dbs.compat.ASpatialDb;
import org.hortonmachine.dbs.compat.objects.QueryResult;
import org.hortonmachine.dbs.datatypes.ESpatialiteGeometryType;
import org.hortonmachine.dbs.spatialite.hm.HMImportExportUtils;
import org.hortonmachine.dbs.utils.BasicStyle;
import org.hortonmachine.gears.io.geopaparazzi.styles.GeopaparazziDatabaseProperties;
import org.hortonmachine.gears.io.vectorreader.OmsVectorReader;
import org.hortonmachine.gears.libs.exceptions.ModelsIOException;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.spatialite.GTSpatialiteThreadsafeDb;
import org.hortonmachine.gears.utils.CrsUtilities;
import org.hortonmachine.gears.utils.SldUtilities;
import org.hortonmachine.gears.utils.files.FileUtilities;
import org.hortonmachine.gears.utils.geometry.EGeometryType;
import org.hortonmachine.gears.utils.style.FeatureTypeStyleWrapper;
import org.hortonmachine.gears.utils.style.LineSymbolizerWrapper;
import org.hortonmachine.gears.utils.style.PointSymbolizerWrapper;
import org.hortonmachine.gears.utils.style.PolygonSymbolizerWrapper;
import org.hortonmachine.gears.utils.style.RuleWrapper;
import org.hortonmachine.gears.utils.style.StyleWrapper;
import org.hortonmachine.gears.utils.style.SymbolizerWrapper;
import org.hortonmachine.gears.utils.style.TextSymbolizerWrapper;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.expression.Expression;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Description(value="Creates a spatialite database for geopaparazzi from a set of shapefiles or adds to an existing one.")
@Author(name="Andrea Antonello, Silvia Franceschi", contact="www.hydrologis.com")
@Keywords(value="geopaparazzi, vector")
@Label(value="Mobile")
@Name(value="geopaparazzispatialitecreator")
@Status(value=10)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class GeopaparazziSpatialiteCreator
extends HMModel {
    @Description(value="The existing or new spatialite database file.")
    @UI(value="infile_gpap")
    @In
    public String inGeopaparazzi = null;
    @Description(value="The encoding to use for the import.")
    @In
    public String pEncoding = "UTF-8";
    @Description(value="A multiplication factor between SLD and geopap sizes (applies to border widths and sizes).")
    @In
    public int pSizeFactor = 3;
    @Description(value="A multiplication factor between SLD and geopap line widths (applies to line widths).")
    @In
    public int pLinesWidthFactor = 6;
    @Description(value="The folder of shapefiles to import.")
    @UI(value="infolder")
    @In
    public String inShapefilesFolder = null;
    public static final String THE_GEOPAPARAZZI_DATABASE_FILE = "The existing or new spatialite database file.";
    public static final String DESCRIPTION = "Creates a spatialite database for geopaparazzi from a set of shapefiles or adds to an existing one.";
    public static final String OmsGeopaparazziSpatialiteCreator_LABEL = "Vector Processing";
    public static final String OmsGeopaparazziSpatialiteCreator_encoding = "The encoding to use for the import.";
    public static final String OmsGeopaparazziSpatialiteCreator_sizefactor = "A multiplication factor between SLD and geopap sizes (applies to border widths and sizes).";
    public static final String OmsGeopaparazziSpatialiteCreator_lineswidthfactor = "A multiplication factor between SLD and geopap line widths (applies to line widths).";
    public static final String OmsGeopaparazziSpatialiteCreator_TAGS = "geopaparazzi, vector";
    public static final String OmsGeopaparazziSpatialiteCreator_NAME = "geopaparazzispatialitecreator";
    public static final String OmsGeopaparazziSpatialiteCreator_inShapefilesFolder = "The folder of shapefiles to import.";

    @Execute
    public void process() throws Exception {
        File shpFolder;
        File[] shpfiles;
        this.checkNull(new Object[]{this.inGeopaparazzi, this.inShapefilesFolder});
        if (this.pEncoding == null || this.pEncoding.trim().length() == 0) {
            this.pEncoding = "UTF-8";
        }
        if (this.pSizeFactor < 1) {
            this.pSizeFactor = 3;
        }
        if (this.pLinesWidthFactor < 1) {
            this.pLinesWidthFactor = 6;
        }
        if ((shpfiles = (shpFolder = new File(this.inShapefilesFolder)).listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".shp");
            }
        })).length == 0) {
            throw new ModelsIOException("The supplied folder doesn't contain any shapefile.", (Object)this);
        }
        try (GTSpatialiteThreadsafeDb db = new GTSpatialiteThreadsafeDb();){
            if (!db.open(this.inGeopaparazzi)) {
                db.initSpatialMetadata(null);
            }
            if (!db.hasTable("dataproperties")) {
                GeopaparazziDatabaseProperties.createPropertiesTable((ASpatialDb)db);
            } else {
                File[] qres1 = db.getTableRecordsMapFromRawSql("select * from dataproperties", 10);
                this.pm.message("Dataproperties already existing: ");
                for (Object[] objs : qres1.data) {
                    this.pm.message(Arrays.toString(objs));
                }
                this.pm.message("----------------------------------");
            }
            this.pm.beginTask("Importing shapefiles...", shpfiles.length);
            for (File shpFile : shpfiles) {
                String name = FileUtilities.getNameWithoutExtention((File)shpFile);
                if (db.hasTable(name)) {
                    this.pm.errorMessage("Table already existing: " + name);
                    continue;
                }
                SimpleFeatureCollection fc = OmsVectorReader.readVector((String)shpFile.getAbsolutePath());
                SimpleFeatureType schema = (SimpleFeatureType)fc.getSchema();
                CoordinateReferenceSystem crs = schema.getCoordinateReferenceSystem();
                String epsgStr = CrsUtilities.getCodeFromCrs((CoordinateReferenceSystem)crs);
                String sirdStr = epsgStr.substring(5);
                int srid = Integer.parseInt(sirdStr);
                EGeometryType geomType = EGeometryType.forGeometryDescriptor((GeometryDescriptor)schema.getGeometryDescriptor());
                ESpatialiteGeometryType spatialiteGeometryType = geomType.toSpatialiteGeometryType();
                HMImportExportUtils.importShapefileThroughVirtualTable((ASpatialDb)db, (String)name, (String)shpFile.getAbsolutePath(), (String)this.pEncoding, (int)srid, (ESpatialiteGeometryType)spatialiteGeometryType);
                Style style = SldUtilities.getStyleFromFile((File)shpFile);
                if (style != null) {
                    String uniqueName = "/#" + name + "#geometry";
                    StyleWrapper styleWrapper = new StyleWrapper(style);
                    List featureTypeStylesWrapperList = styleWrapper.getFeatureTypeStylesWrapperList();
                    if (featureTypeStylesWrapperList.size() > 0) {
                        ArrayList<RuleWrapper> rulesWrapperList = new ArrayList<RuleWrapper>();
                        for (FeatureTypeStyleWrapper ftsWrapper : featureTypeStylesWrapperList) {
                            List rulesWrappers = ftsWrapper.getRulesWrapperList();
                            rulesWrapperList.addAll(rulesWrappers);
                        }
                        if (rulesWrapperList.size() == 1) {
                            RuleWrapper ruleWrapper = (RuleWrapper)rulesWrapperList.get(0);
                            SymbolizerWrapper geometrySymbolizersWrapper = ruleWrapper.getGeometrySymbolizersWrapper();
                            if (geometrySymbolizersWrapper != null) {
                                BasicStyle gpStyle = this.createBaseStyle((ASpatialDb)db, uniqueName, rulesWrapperList);
                                this.populateStyleObject(gpStyle, geometrySymbolizersWrapper);
                                GeopaparazziDatabaseProperties.updateStyle((ASpatialDb)db, (BasicStyle)gpStyle);
                            }
                        } else if (rulesWrapperList.size() > 1) {
                            BasicStyle gpStyle = this.createBaseStyle((ASpatialDb)db, uniqueName, rulesWrapperList);
                            gpStyle.themeMap = new HashMap();
                            for (RuleWrapper ruleWrapper : rulesWrapperList) {
                                SymbolizerWrapper geometrySymbolizersWrapper = ruleWrapper.getGeometrySymbolizersWrapper();
                                BasicStyle themeStyle = this.createBaseStyle(null, uniqueName, rulesWrapperList);
                                this.populateStyleObject(themeStyle, geometrySymbolizersWrapper);
                                Filter filter = ruleWrapper.getRule().getFilter();
                                if (!(filter instanceof IsEqualsToImpl)) continue;
                                IsEqualsToImpl equalsFilter = (IsEqualsToImpl)filter;
                                Expression expression1 = equalsFilter.getExpression1();
                                Expression expression2 = equalsFilter.getExpression2();
                                this.setFilter(gpStyle, themeStyle, expression1);
                                this.setFilter(gpStyle, themeStyle, expression2);
                            }
                            GeopaparazziDatabaseProperties.updateStyle((ASpatialDb)db, (BasicStyle)gpStyle);
                        } else {
                            this.pm.errorMessage("Unable to export SLD for: " + shpFile);
                            continue;
                        }
                    }
                }
                this.pm.worked(1);
            }
            this.pm.done();
            QueryResult qres = db.getTableRecordsMapFromRawSql("select * from dataproperties", 100);
            this.pm.message("Dataproperties inserted: ");
            int theme = qres.names.indexOf("theme");
            for (Object[] objs : qres.data) {
                String themeString = objs[theme].toString().replaceAll("\\s+", " ");
                if (themeString.length() > 20) {
                    objs[theme] = themeString.substring(0, 15) + "...";
                }
                this.pm.message(Arrays.toString(objs));
            }
        }
    }

    private void setFilter(BasicStyle mainStyle, BasicStyle themeStyle, Expression expression) {
        if (expression instanceof AttributeExpressionImpl) {
            AttributeExpressionImpl attr = (AttributeExpressionImpl)expression;
            mainStyle.themeField = attr.getPropertyName();
        } else if (expression instanceof LiteralExpressionImpl) {
            LiteralExpressionImpl attr = (LiteralExpressionImpl)expression;
            mainStyle.themeMap.put(attr.getValue().toString(), themeStyle);
        }
    }

    private void populateStyleObject(BasicStyle gpStyle, SymbolizerWrapper geometrySymbolizersWrapper) {
        if (geometrySymbolizersWrapper instanceof PointSymbolizerWrapper) {
            PointSymbolizerWrapper psw = (PointSymbolizerWrapper)geometrySymbolizersWrapper;
            gpStyle.shape = psw.getMarkName();
            gpStyle.size = (double)this.pSizeFactor * this.getDouble(psw.getSize(), gpStyle.size);
            gpStyle.width = (double)this.pSizeFactor * this.getDouble(psw.getStrokeWidth(), gpStyle.width);
            gpStyle.strokealpha = this.getDouble(psw.getStrokeOpacity(), gpStyle.strokealpha);
            gpStyle.strokecolor = this.getString(psw.getStrokeColor(), null);
            gpStyle.fillalpha = this.getDouble(psw.getFillOpacity(), gpStyle.fillalpha);
            gpStyle.fillcolor = this.getString(psw.getFillColor(), null);
        } else if (geometrySymbolizersWrapper instanceof PolygonSymbolizerWrapper) {
            PolygonSymbolizerWrapper psw = (PolygonSymbolizerWrapper)geometrySymbolizersWrapper;
            gpStyle.width = (double)this.pSizeFactor * this.getDouble(psw.getStrokeWidth(), gpStyle.width);
            gpStyle.strokealpha = this.getDouble(psw.getStrokeOpacity(), gpStyle.strokealpha);
            gpStyle.strokecolor = this.getString(psw.getStrokeColor(), null);
            gpStyle.fillalpha = this.getDouble(psw.getFillOpacity(), gpStyle.fillalpha);
            gpStyle.fillcolor = this.getString(psw.getFillColor(), null);
        } else if (geometrySymbolizersWrapper instanceof LineSymbolizerWrapper) {
            LineSymbolizerWrapper lsw = (LineSymbolizerWrapper)geometrySymbolizersWrapper;
            gpStyle.width = (double)this.pLinesWidthFactor * this.getDouble(lsw.getStrokeWidth(), gpStyle.width);
            gpStyle.strokealpha = this.getDouble(lsw.getStrokeOpacity(), gpStyle.strokealpha);
            gpStyle.strokecolor = this.getString(lsw.getStrokeColor(), null);
        }
    }

    private BasicStyle createBaseStyle(ASpatialDb db, String uniqueName, List<RuleWrapper> rulesWrapperListForTextSymbolizer) throws Exception {
        String fieldLabel = "";
        TextSymbolizerWrapper textSymbolizersWrapper = null;
        if (rulesWrapperListForTextSymbolizer != null) {
            for (RuleWrapper ruleWrapper : rulesWrapperListForTextSymbolizer) {
                textSymbolizersWrapper = ruleWrapper.getTextSymbolizersWrapper();
                if (textSymbolizersWrapper == null) continue;
                fieldLabel = textSymbolizersWrapper.getLabelName();
                break;
            }
        }
        BasicStyle gpStyle = GeopaparazziDatabaseProperties.createDefaultPropertiesForTable((ASpatialDb)db, (String)uniqueName, (String)fieldLabel);
        if (fieldLabel != null && fieldLabel.trim().length() > 0 && textSymbolizersWrapper != null) {
            String fontSize = textSymbolizersWrapper.getFontSize();
            try {
                double fontSizeDouble = Double.parseDouble(fontSize);
                gpStyle.labelsize = (float)fontSizeDouble * (float)this.pSizeFactor;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return gpStyle;
    }

    private double getDouble(String value, double defaultValue) {
        double num = defaultValue;
        try {
            num = Double.parseDouble(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return num;
    }

    private String getString(String value, String defaultValue) {
        if (value == null || value.trim().length() == 0) {
            value = defaultValue;
        }
        return value;
    }

    public static void main(String[] args) throws Exception {
        GeopaparazziSpatialiteCreator c = new GeopaparazziSpatialiteCreator();
        c.inGeopaparazzi = "/home/hydrologis/data/naturalearth_italy_thematic.sqlite";
        c.pEncoding = null;
        c.inShapefilesFolder = "/home/hydrologis/data/naturalearth_italy_thematic";
        c.process();
    }
}

