/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.hmachine.modules.hydrogeomorphology.hecras.OmsHecrasInputBuilder;

@Description(value="Module that prepares input data for Hecras.")
@Author(name="Andrea Antonello, Silvia Franceschi", contact="www.hydrologis.com")
@Keywords(value="Hecras, Raster, Vector, Hydraulic")
@Label(value="HortonMachine/Hydro-Geomorphology")
@Name(value="inhecras")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class HecrasInputBuilder
extends HMModel {
    @Description(value="The river points with elevation.")
    @UI(value="infile_vector")
    @In
    public String inRiverPoints = null;
    @Description(value="The section lines.")
    @UI(value="infile_vector")
    @In
    public String inSections = null;
    @Description(value="The section points (with the elevation in the attribute table).")
    @UI(value="infile_vector")
    @In
    public String inSectionPoints = null;
    @Description(value="The id of the river/simulation.")
    @In
    public String pTitle = "DEFAULTID";
    @Description(value="The path to the generated hecras.")
    @In
    @UI(value="outfile")
    public String outHecras = null;

    @Execute
    public void process() throws Exception {
        OmsHecrasInputBuilder hecrasinputbuilder = new OmsHecrasInputBuilder();
        hecrasinputbuilder.inRiverPoints = this.getVector(this.inRiverPoints);
        hecrasinputbuilder.inSections = this.getVector(this.inSections);
        hecrasinputbuilder.inSectionPoints = this.getVector(this.inSectionPoints);
        hecrasinputbuilder.pTitle = this.pTitle;
        hecrasinputbuilder.outHecras = this.outHecras;
        hecrasinputbuilder.pm = this.pm;
        hecrasinputbuilder.doProcess = this.doProcess;
        hecrasinputbuilder.doReset = this.doReset;
        hecrasinputbuilder.process();
    }
}

