/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.hmachine.modules.hydrogeomorphology.lwrecruitment.OmsLW06_SlopeToNetworkAdder;

@Description(value="Add the local slope attribute to the input channel point layer.")
@Author(name="Silvia Franceschi, Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="network, vector, point, bankflull, width")
@Label(value="HortonMachine/Hydro-Geomorphology/LWRecruitment")
@Name(value="lw06_slopetonetworkadder")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class LW06_SlopeToNetworkAdder
extends HMModel {
    @Description(value="The input hierarchy point network layer.")
    @UI(value="infile_vector")
    @In
    public String inNetPoints = null;
    @Description(value="The input slope raster map")
    @UI(value="infile_raster")
    @In
    public String inSlope = null;
    @Description(value="The output points network layer with the additional attribute of local slope.")
    @UI(value="outfile")
    @In
    public String outNetPoints = null;

    @Execute
    public void process() throws Exception {
        OmsLW06_SlopeToNetworkAdder m = new OmsLW06_SlopeToNetworkAdder();
        m.inNetPoints = this.getVector(this.inNetPoints);
        m.inSlope = this.getRaster(this.inSlope);
        m.pm = this.pm;
        m.process();
        this.dumpVector(m.outNetPoints, this.outNetPoints);
    }
}

