/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import java.io.File;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.modules.docker.PdalDockerModel;
import org.json.JSONObject;

@Description(value="PDAL filter.elm command: Extended Local Minimum")
@Author(name="Antonello Andrea", contact="http://www.hydrologis.com")
@Keywords(value="pdal, filter, elm, docker")
@Label(value="Pdal")
@Name(value="_pdal_filter_elm")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class PdalFilterElm
extends PdalDockerModel {
    @Description(value="The pdal file to filter.")
    @UI(value="infile_las")
    @In
    public String inPath = null;
    @Description(value="The output file name.")
    @In
    public String outName = null;
    @Description(value="Threshold value to identify low noise points.")
    @In
    public Double pThreshold = 1.0;
    @Description(value="Cell size.")
    @In
    public Double pCell = 10.0;
    @Description(value="Classification value to apply to noise points.")
    @In
    public Double pClassification;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Execute
    public void process() throws Exception {
        this.checkFileExists(new String[]{this.inPath});
        String error = this.checkDockerInstall();
        if (error == null) {
            try {
                File file = new File(this.inPath);
                String inName = file.getName();
                File workspaceFile = file.getParentFile();
                String workspace = workspaceFile.getAbsolutePath();
                JSONObject filter = new JSONObject();
                filter.put("type", (Object)"filters.elm");
                filter.put("threshold", (Object)this.pThreshold);
                filter.put("cell", (Object)this.pCell);
                if (this.pClassification != null) {
                    filter.put("class", (Object)this.pClassification);
                }
                String pipelineJson = this.getPipelineJson(inName, this.outName, filter);
                this.pm.message("Running pipeline with filter:");
                this.pm.message(pipelineJson);
                File pipelineFile = this.getPipelineFile(workspaceFile, pipelineJson);
                String cmd = "pdal pipeline " + pipelineFile.getName();
                this.startContainer(workspace);
                this.pm.beginTask("Running command...", -1);
                this.execCommand(cmd);
                this.pm.done();
                pipelineFile.delete();
            }
            finally {
                this.closeClient();
            }
        } else {
            this.pm.errorMessage(error);
        }
    }

    public static void main(String[] args) throws Exception {
        PdalFilterElm i = new PdalFilterElm();
        i.inPath = "/Users/hydrologis/data/las/EXAMPLE_river.las";
        i.pThreshold = 30.0;
        i.pThreshold = 10.0;
        i.outName = "filtered.las";
        i.process();
    }
}

