/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import org.hortonmachine.modules.docker.PdalDockerModel;

@Description(value="Pdal installer command.")
@Author(name="Antonello Andrea, Silvia Franceschi", contact="http://www.hydrologis.com")
@Keywords(value="pdal, docker")
@Label(value="Pdal")
@Name(value="_pdalinstaller")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class PdalInstaller
extends PdalDockerModel {
    @Description(value="Force image removal and new download.")
    @In
    public boolean doForce = false;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Execute
    public void process() throws Exception {
        String error = this.checkDockerInstall();
        if (error == null) {
            try {
                String imageId = this.hasImage();
                if (imageId != null && this.doForce) {
                    this.removeImage(imageId);
                    imageId = this.hasImage();
                }
                if (imageId != null) return;
                this.pm.beginTask("Downloading pdal image. This will take a while depending on your network quality...", -1);
                this.pullImage(this.pm);
                this.pm.done();
                return;
            }
            finally {
                this.closeClient();
            }
        } else {
            this.pm.errorMessage(error);
        }
    }

    public static void main(String[] args) throws Exception {
        PdalInstaller i = new PdalInstaller();
        i.doForce = true;
        i.process();
    }
}

