/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import oms3.annotations.Unit;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.hmachine.modules.hydrogeomorphology.scsrunoff.OmsScsRunoff;

@Description(value="The SCS Runoff model.")
@Author(name="The klab team.", contact="www.integratedmodelling.org")
@Keywords(value="SCS, Runoff")
@Label(value="HortonMachine/Hydro-Geomorphology")
@Name(value="ScsRunoff")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class ScsRunoff
extends HMModel {
    @Description(value="The rainfall volume.")
    @UI(value="infile_raster")
    @Unit(value="mm")
    @In
    public String inRainfall = null;
    @Description(value="The network map.")
    @UI(value="infile_raster")
    @In
    public String inNet = null;
    @Description(value="The map of Curvenumber.")
    @UI(value="infile_raster")
    @In
    public String inCurveNumber = null;
    @Description(value="Number of events (if null, defaults to 1)")
    @UI(value="infile_raster")
    @In
    public String inNumberOfEvents;
    @Description(value="The output runoff.")
    @UI(value="outfile")
    @In
    public String outputDischarge;

    @Execute
    public void process() throws Exception {
        OmsScsRunoff rf = new OmsScsRunoff();
        rf.inRainfall = this.getRaster(this.inRainfall);
        rf.inNet = this.getRaster(this.inNet);
        rf.inCurveNumber = this.getRaster(this.inCurveNumber);
        rf.inNumberOfEvents = this.getRaster(this.inNumberOfEvents);
        rf.pm = this.pm;
        rf.process();
        this.dumpRaster(rf.outputDischarge, this.outputDischarge);
    }
}

