/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.hmachine.modules.basin.topindex.OmsTopIndex;

@Description(value="Topographic index calculator.")
@Author(name="Daniele Andreis, Antonello Andrea, Erica Ghesla, Cozzini Andrea, Franceschi Silvia, Pisoni Silvano, Rigon Riccardo", contact="http://www.hydrologis.com, http://www.ing.unitn.it/dica/hp/?user=rigon")
@Keywords(value="Hydrology")
@Label(value="HortonMachine/Basin")
@Name(value="_topindex")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class TopIndex
extends HMModel {
    @Description(value="The map of the contributing area.")
    @UI(value="infile_raster")
    @In
    public String inTca = null;
    @Description(value="The map of slope.")
    @UI(value="infile_raster")
    @In
    public String inSlope = null;
    @Description(value="The map of the topographic index.")
    @UI(value="outfile")
    @In
    public String outTopindex = null;

    @Execute
    public void process() throws Exception {
        OmsTopIndex topindex = new OmsTopIndex();
        topindex.inTca = this.getRaster(this.inTca);
        topindex.inSlope = this.getRaster(this.inSlope);
        topindex.pm = this.pm;
        topindex.doProcess = this.doProcess;
        topindex.doReset = this.doReset;
        topindex.process();
        this.dumpRaster(topindex.outTopindex, this.outTopindex);
    }
}

