/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.hmachine.modules.hydrogeomorphology.baseflow.OmsBaseflowWaterVolume;

@Description(value="The Baseflow Watervolume model (from INVEST).")
@Author(name="The klab team.", contact="www.integratedmodelling.org")
@Keywords(value="baseflow")
@Label(value="HortonMachine/Hydro-Geomorphology")
@Name(value="BaseflowWaterVolume")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class BaseflowWaterVolume
extends HMModel {
    @Description(value="The infiltrated watervolume.")
    @UI(value="infile_raster")
    @In
    public String inInfiltration = null;
    @Description(value="The net infiltrated watervolume.")
    @UI(value="infile_raster")
    @In
    public String inNetInfiltration = null;
    @Description(value="The map of net.")
    @UI(value="infile_raster")
    @In
    public String inNet = null;
    @Description(value="The map of flowdirections (D8).")
    @UI(value="infile_raster")
    @In
    public String inFlowdirections = null;
    @Description(value="The map of Lsum.")
    @UI(value="outfile")
    @In
    public String outLsum = null;
    @Description(value="The map of single cell baseflow.")
    @UI(value="outfile")
    @In
    public String outB = null;
    @Description(value="The map of contribution of local recharge in pixel to baseflow.")
    @UI(value="outfile")
    @In
    public String outVri = null;
    @Description(value="The total baseflow.")
    @Out
    public Double outQb = null;
    @Description(value="The Vri sum value.")
    @Out
    public Double outVriSum = null;
    @Description(value="The map of cumulated baseflow.")
    @UI(value="outfile")
    @In
    public String outBaseflow = null;

    @Execute
    public void process() throws Exception {
        OmsBaseflowWaterVolume bf = new OmsBaseflowWaterVolume();
        bf.pm = this.pm;
        bf.inInfiltration = this.getRaster(this.inInfiltration);
        bf.inNetInfiltration = this.getRaster(this.inNetInfiltration);
        bf.inNet = this.getRaster(this.inNet);
        bf.inFlowdirections = this.getRaster(this.inFlowdirections);
        bf.process();
        this.dumpRaster(bf.outBaseflow, this.outBaseflow);
        this.dumpRaster(bf.outLsum, this.outLsum);
        this.dumpRaster(bf.outVri, this.outVri);
        this.dumpRaster(bf.outB, this.outB);
        this.outQb = bf.outQb;
        this.outVriSum = bf.outVriSum;
    }
}

