/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import java.io.File;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.utils.files.FileUtilities;
import org.hortonmachine.modules.docker.GdalDockerModel;

@Description(value="A raster to tiff converter.")
@Author(name="Antonello Andrea", contact="http://www.hydrologis.com")
@Keywords(value="gdal, docker, raster, tiff")
@Label(value="Gdal")
@Name(value="_gdalraster2tiffconverter")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class GdalRaster2TiffConverter
extends GdalDockerModel {
    @Description(value="The raster file to convert.")
    @UI(value="infile_raster")
    @In
    public String inRaster = null;
    @Description(value="Force creation of tiled a tiff.")
    @In
    public boolean doTiles = true;
    @Description(value="Use jpeg compression")
    @In
    public boolean doJpegCompression = false;
    @Description(value="Additional options. The format is COMPRESS=DEFLATE or TFW=YES")
    @In
    public String pOptions = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Execute
    public void process() throws Exception {
        String error = this.checkDockerInstall();
        if (error == null) {
            try {
                this.checkNull(new Object[]{this.inRaster});
                this.checkFileExists(new String[]{this.inRaster});
                File file = new File(this.inRaster);
                String inName = file.getName();
                String outName = FileUtilities.getNameWithoutExtention((File)file) + ".tiff";
                String workspace = file.getParentFile().getAbsolutePath();
                Object cmd = "gdal_translate -of GTiff";
                if (this.doTiles) {
                    cmd = (String)cmd + " -co TILED=YES";
                }
                if (this.doJpegCompression) {
                    cmd = (String)cmd + " -co COMPRESS=JPEG";
                }
                if (this.pOptions != null) {
                    String[] split;
                    for (String option : split = this.pOptions.split("\\s+")) {
                        cmd = (String)cmd + " -co " + option;
                    }
                }
                cmd = (String)cmd + " " + inName + " " + outName;
                this.pm.message((String)cmd);
                this.startContainer(workspace);
                this.execCommand((String)cmd);
            }
            finally {
                this.closeClient();
            }
        } else {
            this.pm.errorMessage(error);
        }
    }

    public static void main(String[] args) throws Exception {
        GdalRaster2TiffConverter i = new GdalRaster2TiffConverter();
        i.inRaster = "/Users/hydrologis/data/DTM_calvello/dtm_all.asc";
        i.doTiles = true;
        i.pOptions = "COMPRESS=DEFLATE TFW=YES";
        i.process();
    }
}

